/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.collision;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import me.moros.bending.common.collision.CollisionQuery;

record CollisionQueryImpl<E>(Collection<CollisionQuery.Pair<E>> potentialCollisions) implements CollisionQuery<E>
{
    CollisionQueryImpl() {
        this(new HashSet<CollisionQuery.Pair<E>>(32));
    }

    void add(E first, E second) {
        this.potentialCollisions.add(new SimplePair<E>(first, second));
    }

    @Override
    public Iterator<CollisionQuery.Pair<E>> iterator() {
        return new Itr<CollisionQuery.Pair<E>>(this.potentialCollisions.iterator());
    }

    record SimplePair<E>(E first, E second) implements CollisionQuery.Pair<E>
    {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SimplePair other = (SimplePair)obj;
            return this.first == other.first && this.second == other.second || this.first == other.second && this.second == other.first;
        }

        @Override
        public int hashCode() {
            int maxHash = Math.max(this.first.hashCode(), this.second.hashCode());
            int minHash = Math.min(this.first.hashCode(), this.second.hashCode());
            return 31 * minHash + maxHash;
        }
    }

    record Itr<E>(Iterator<E> iterator) implements Iterator<E>
    {
        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }
    }
}

