/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command;

import java.util.List;
import java.util.function.Function;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.Bending;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.commands.AttributeCommand;
import me.moros.bending.common.command.commands.BackupCommand;
import me.moros.bending.common.command.commands.BindCommand;
import me.moros.bending.common.command.commands.BoardCommand;
import me.moros.bending.common.command.commands.ElementCommand;
import me.moros.bending.common.command.commands.HelpCommand;
import me.moros.bending.common.command.commands.ModifierCommand;
import me.moros.bending.common.command.commands.PresetCommand;
import me.moros.bending.common.command.commands.ReloadCommand;
import me.moros.bending.common.command.commands.ToggleCommand;
import me.moros.bending.common.command.commands.VersionCommand;
import me.moros.bending.common.command.parser.ComponentException;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.ComponentLike;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.execution.preprocessor.CommandPreprocessingContext;
import org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import org.incendo.cloud.minecraft.extras.RichDescription;

record CommanderImpl<C extends Audience>(CommandManager<C> manager, Class<? extends C> playerType, Bending plugin) implements Commander<C>
{
    @Override
    public void init() {
        this.registerExceptionHandler();
        this.manager().registerCommandPreProcessor(this::preprocessor);
        List<Function> cmds = List.of(HelpCommand::new, VersionCommand::new, ReloadCommand::new, BackupCommand::new, BoardCommand::new, ToggleCommand::new, BindCommand::new, ElementCommand::new, ModifierCommand::new, AttributeCommand::new, PresetCommand::new);
        cmds.forEach(cmd -> ((Initializer)cmd.apply(this)).init());
    }

    @Override
    public Command.Builder<C> rootBuilder() {
        return this.manager().commandBuilder("bending", (Description)RichDescription.of((ComponentLike)Message.BASE_DESC.build()), new String[]{"b"});
    }

    @Override
    public void register(Command.Builder<? extends C> builder) {
        this.manager().command(builder);
    }

    private void registerExceptionHandler() {
        MinecraftExceptionHandler.createNative().defaultHandlers().decorator(Message::brand).handler(ComponentException.class, (f, ctx) -> ((ComponentException)ctx.exception()).componentMessage()).registerTo(this.manager());
    }

    private void preprocessor(CommandPreprocessingContext<C> context) {
        ((Audience)context.commandContext().sender()).get(Identity.UUID).ifPresent(uuid -> {
            User user = (User)Registries.BENDERS.get(uuid);
            if (user instanceof Player) {
                context.commandContext().store(ContextKeys.BENDING_PLAYER, (Object)user);
            }
        });
    }
}

