/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.parser;

import java.util.function.Predicate;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.command.CommandUtil;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.parser.ComponentException;
import me.moros.bending.common.locale.Message;
import net.kyori.adventure.audience.Audience;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

public final class AbilityParser<C extends Audience>
implements ArgumentParser<C, AbilityDescription>,
BlockingSuggestionProvider.Strings<C> {
    private final boolean validBindsOnly;

    private AbilityParser(boolean validBindsOnly) {
        this.validBindsOnly = validBindsOnly;
    }

    public ArgumentParseResult<AbilityDescription> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        AbilityDescription check = Registries.ABILITIES.fromString(input);
        if (check != null && !check.hidden()) {
            commandInput.readString();
            return ArgumentParseResult.success((Object)check);
        }
        return ArgumentParseResult.failure((Throwable)new ComponentException(Message.ABILITY_PARSE_EXCEPTION.build(input)));
    }

    public Iterable<String> stringSuggestions(CommandContext<C> commandContext, CommandInput commandInput) {
        Predicate<AbilityDescription> predicate = d -> !d.hidden();
        User user = commandContext.optional(ContextKeys.BENDING_PLAYER).orElse(null);
        if (this.validBindsOnly) {
            predicate = predicate.and(AbilityDescription::canBind);
            if (user != null) {
                predicate = predicate.and(desc -> user.hasElements(desc.elements()));
            }
        }
        if (user != null) {
            predicate = predicate.and(user::hasPermission);
        }
        return Registries.ABILITIES.stream().filter(predicate).map(CommandUtil::mapToSuggestion).toList();
    }

    public static <C extends Audience> ParserDescriptor<C, AbilityDescription> parser() {
        return ParserDescriptor.of(new AbilityParser<C>(true), AbilityDescription.class);
    }

    public static <C extends Audience> ParserDescriptor<C, AbilityDescription> parserGlobal() {
        return ParserDescriptor.of(new AbilityParser<C>(false), AbilityDescription.class);
    }
}

