/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import me.moros.bending.api.platform.property.Property;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.data.DataKeyed;
import me.moros.bending.common.data.DataProvider;
import me.moros.bending.common.data.DataProviderBuilder;
import me.moros.bending.common.data.DataProviderRegistryImpl;
import org.checkerframework.checker.nullness.qual.Nullable;

public sealed interface DataProviderRegistry<T>
permits DataProviderRegistryImpl {
    public <V> @Nullable DataProvider<T, V> getProvider(DataKeyed<V> var1);

    default public <V> @Nullable V getValue(DataKeyed<V> dataKeyed, T instance) {
        DataProvider<T, V> provider = this.getProvider(dataKeyed);
        if (provider != null) {
            return provider.get(instance);
        }
        return null;
    }

    default public <V> boolean setValue(DataKeyed<V> dataKeyed, T instance, V value) {
        DataProvider<T, V> provider;
        Property property;
        if (dataKeyed instanceof Property && (property = (Property)dataKeyed).isValidValue(value) && (provider = this.getProvider(dataKeyed)) != null) {
            return provider.set(instance, value);
        }
        return false;
    }

    default public <V> boolean editValue(DataKeyed<V> dataKeyed, T instance, UnaryOperator<V> operator) {
        V oldValue;
        DataProvider provider = this.getProvider(dataKeyed);
        if (provider != null && (oldValue = provider.get(instance)) != null) {
            Property property;
            Object value = operator.apply(oldValue);
            if (dataKeyed instanceof Property && (property = (Property)dataKeyed).isValidValue(value)) {
                return provider.set(instance, value);
            }
        }
        return false;
    }

    public static <T> Builder<T> builder(Class<T> baseType) {
        Objects.requireNonNull(baseType);
        return new Builder<T>(baseType);
    }

    public static final class Builder<T> {
        private final Map<DataKey<?>, DataProvider<? extends T, ?>> propertyMap = new HashMap();
        private final Class<T> baseType;

        private Builder(Class<T> baseType) {
            this.baseType = baseType;
        }

        public <T1 extends T, V> Builder<T> create(DataKeyed<V> dataKeyed, Class<T1> type, Consumer<DataProviderBuilder<T, T1, V>> consumer) {
            DataProviderBuilder builder = new DataProviderBuilder(this.extractPredicate(type));
            consumer.accept(builder);
            this.propertyMap.put(dataKeyed.dataKey(), builder.validateAndBuildProvider());
            return this;
        }

        public DataProviderRegistry<T> build() {
            if (this.propertyMap.isEmpty()) {
                throw new IllegalStateException("No properties registered.");
            }
            return new DataProviderRegistryImpl(Map.copyOf(this.propertyMap));
        }

        private <T1 extends T> Predicate<T1> extractPredicate(Class<T1> type) {
            return type.equals(this.baseType) ? o -> true : type::isInstance;
        }
    }
}

