/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionPair;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.game.AbilityManager;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.common.collision.AABBUtil;
import me.moros.bending.common.collision.Boundable;
import me.moros.bending.common.collision.CollisionData;
import me.moros.bending.common.collision.CollisionQuery;
import me.moros.bending.common.collision.LBVH;
import me.moros.bending.common.collision.MortonEncoded;
import me.moros.math.FastMath;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CollisionManager
implements Updatable {
    private final AbilityManager manager;

    CollisionManager(AbilityManager manager) {
        this.manager = manager;
    }

    private CachedAbility[] filterAndCollect() {
        ArrayList<CachedAbility> instances = new ArrayList<CachedAbility>(FastMath.ceil(0.5 * (double)this.manager.size()));
        for (Ability ability : this.manager) {
            Collection<Collider> colliders = ability.colliders();
            if (colliders.isEmpty()) continue;
            instances.add(CachedAbility.create(ability, colliders));
        }
        return (CachedAbility[])instances.toArray(CachedAbility[]::new);
    }

    @Override
    public Updatable.UpdateResult update() {
        Boundable[] instances = this.filterAndCollect();
        if (instances.length < 2) {
            return Updatable.UpdateResult.CONTINUE;
        }
        Set<CachedAbility> pruned = Collections.newSetFromMap(new IdentityHashMap(instances.length));
        LBVH bvh = LBVH.buildTree((Boundable[])instances);
        CollisionQuery query = bvh.queryAll();
        for (CollisionQuery.Pair pair : query) {
            this.processPotentialCollision(pair, pruned);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private void processPotentialCollision(CollisionQuery.Pair<CachedAbility> queryPair, Set<CachedAbility> pruned) {
        CachedAbility secondEntry;
        CachedAbility firstEntry = queryPair.first();
        if (firstEntry.isSameUser(secondEntry = queryPair.second()) || pruned.contains(firstEntry) || pruned.contains(secondEntry)) {
            return;
        }
        Ability first = firstEntry.ability();
        Ability second = secondEntry.ability();
        CollisionPair pair = Registries.COLLISIONS.get(CollisionPair.createKey(first.description(), second.description()));
        if (pair == null) {
            return;
        }
        Map.Entry<Collider, Collider> collision = this.checkCollision(firstEntry.colliders(), secondEntry.colliders());
        if (collision != null) {
            CollisionData result = this.handleCollision(first, second, collision.getKey(), collision.getValue(), pair);
            if (result.removeFirst()) {
                this.manager.destroyInstance(first);
                pruned.add(firstEntry);
            }
            if (result.removeSecond()) {
                this.manager.destroyInstance(second);
                pruned.add(secondEntry);
            }
        }
    }

    private @Nullable Map.Entry<Collider, Collider> checkCollision(Iterable<Collider> firstColliders, Iterable<Collider> secondColliders) {
        for (Collider firstCollider : firstColliders) {
            for (Collider secondCollider : secondColliders) {
                if (!firstCollider.intersects(secondCollider)) continue;
                return Map.entry(firstCollider, secondCollider);
            }
        }
        return null;
    }

    private CollisionData handleCollision(Ability first, Ability second, Collider c1, Collider c2, CollisionPair pair) {
        boolean invertOrder = first.description() != pair.first();
        boolean removeFirst = invertOrder ? pair.removeSecond() : pair.removeFirst();
        boolean removeSecond = invertOrder ? pair.removeFirst() : pair.removeSecond();
        CollisionData data = new CollisionData(first, second, c1, c2, removeFirst, removeSecond);
        first.onCollision(data.asCollision());
        second.onCollision(data.asInverseCollision());
        return data;
    }

    private record CachedAbility(Ability ability, Collection<Collider> colliders, AABB box, int morton) implements Boundable,
    MortonEncoded
    {
        private boolean isSameUser(CachedAbility other) {
            return this.ability.user().uuid().equals(other.ability.user().uuid());
        }

        private static CachedAbility create(Ability ability, Collection<Collider> colliders) {
            AABB box = AABBUtil.combine(colliders);
            return new CachedAbility(ability, colliders, box, MortonEncoded.calculateMorton(box.position()));
        }
    }
}

