/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.element.ElementHandler;
import me.moros.bending.api.gui.ElementGui;
import me.moros.bending.api.locale.Translation;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.api.util.functional.Suppliers;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.locale.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.TriState;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractGui<ItemStack, T>
implements ElementGui {
    protected static final Supplier<ItemSnapshot> BACKGROUND = Suppliers.lazy(() -> Platform.instance().factory().itemBuilder(Item.BLACK_STAINED_GLASS_PANE).name((Component)Component.empty()).build());
    private final Map<Element, ItemStack> map = new EnumMap<Element, ItemStack>(Element.class);
    private final ElementHandler handler;
    private final Player player;
    private final T gui;

    protected AbstractGui(ElementHandler handler, Player player) {
        this.handler = handler;
        this.player = player;
        this.gui = this.construct(this.map);
    }

    protected T handle() {
        return this.gui;
    }

    protected Player player() {
        return this.player;
    }

    protected abstract T construct(Map<Element, ItemStack> var1);

    protected DataWrapper createElementButton(Element element) {
        List<Component> lore = this.generateLore(element);
        ItemSnapshot item = Platform.instance().factory().itemBuilder(AbstractGui.mapElement(element)).name(element.displayName().decoration(TextDecoration.ITALIC, false)).lore(lore).build();
        return new DataWrapper(element, item);
    }

    protected TriState handleAction(ActionType action, DataWrapper meta) {
        User user = (User)Registries.BENDERS.get(this.player.uuid());
        if (user != null && action.executeCommand(this.handler, user, meta.element())) {
            if (action.keepOpen()) {
                this.handleItemStackGlow(this.map.get((Object)meta.element()), user.hasElement(meta.element()));
                return TriState.TRUE;
            }
            return TriState.FALSE;
        }
        return TriState.NOT_SET;
    }

    protected abstract void handleItemStackGlow(ItemStack var1, boolean var2);

    protected static @Nullable ActionType mapType(boolean shift, boolean left, boolean right) {
        if (shift) {
            if (left) {
                return ActionType.ADD;
            }
            if (right) {
                return ActionType.REMOVE;
            }
        } else {
            if (left) {
                return ActionType.CHOOSE;
            }
            if (right) {
                return ActionType.DISPLAY;
            }
        }
        return null;
    }

    protected ItemSnapshot generateHelpItem() {
        List<Component> lore = ActionType.VALUES.stream().map(type -> type.toEntry(this.player)).toList();
        return Platform.instance().factory().itemBuilder(Item.BOOK).name(Message.ELEMENTS_GUI_HELP_TITLE.build().decoration(TextDecoration.ITALIC, false)).lore(lore).build();
    }

    private List<Component> generateLore(Element element) {
        Component base = GlobalTranslator.render((Component)element.description(), (Locale)((Locale)this.player.getOrDefault(Identity.LOCALE, Translation.DEFAULT_LOCALE)));
        String raw = PlainTextComponentSerializer.plainText().serialize(base);
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String s : TextUtil.wrap(raw, 36)) {
            lore.add((Component)Component.text((String)s, (TextColor)element.color()));
        }
        return lore;
    }

    private static Item mapElement(Element element) {
        return switch (element) {
            default -> throw new MatchException(null, null);
            case Element.AIR -> Item.WHITE_CONCRETE;
            case Element.WATER -> Item.LIGHT_BLUE_CONCRETE;
            case Element.EARTH -> Item.GREEN_CONCRETE;
            case Element.FIRE -> Item.RED_CONCRETE;
        };
    }

    public record DataWrapper(Element element, ItemSnapshot item) {
    }

    protected static enum ActionType {
        CHOOSE(Message.ELEMENTS_GUI_CHOOSE, Permissions.CHOOSE, ElementHandler::onElementChoose, false),
        DISPLAY(Message.ELEMENTS_GUI_DISPLAY, Permissions.HELP, ElementHandler::onElementDisplay, false),
        ADD(Message.ELEMENTS_GUI_ADD, Permissions.ADD, ElementHandler::onElementAdd, true),
        REMOVE(Message.ELEMENTS_GUI_REMOVE, Permissions.REMOVE, ElementHandler::onElementRemove, true);

        private final Message.Args0 message;
        private final String permission;
        private final MenuAction menuAction;
        private final boolean keepOpen;
        private static final Collection<ActionType> VALUES;

        private ActionType(Message.Args0 message, String permission, MenuAction menuAction, boolean keepOpen) {
            this.message = message;
            this.permission = permission;
            this.menuAction = menuAction;
            this.keepOpen = keepOpen;
        }

        public boolean keepOpen() {
            return this.keepOpen;
        }

        public boolean executeCommand(ElementHandler handler, User user, Element element) {
            if (!user.hasPermission(this.permission)) {
                Message.GUI_NO_PERMISSION.send((Audience)user);
                return false;
            }
            this.menuAction.accept(handler, user, element);
            return true;
        }

        private Component toEntry(Player player) {
            return this.message.build().style(s -> s.decoration(TextDecoration.ITALIC, false).decoration(TextDecoration.STRIKETHROUGH, !player.hasPermission(this.permission)));
        }

        static {
            VALUES = List.of(ActionType.values());
        }
    }

    @FunctionalInterface
    protected static interface MenuAction {
        public void accept(ElementHandler var1, User var2, Element var3);
    }
}

