/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.hook;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.resolver.AudienceTagResolver;
import io.github.miniplaceholders.api.utils.Tags;
import java.util.function.Function;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.placeholder.DynamicPlaceholder;
import me.moros.bending.common.placeholder.Placeholder;
import me.moros.bending.common.placeholder.PlaceholderProvider;
import me.moros.bending.common.placeholder.StaticPlaceholder;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.KeyedValue;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;

public record MiniPlaceholdersHook(PlaceholderProvider provider) implements Initializer
{
    public MiniPlaceholdersHook() {
        this(PlaceholderProvider.defaultBuilder().build());
    }

    @Override
    public void init() {
        Expansion.Builder builder = Expansion.builder((String)"bending");
        for (KeyedValue<? extends Placeholder> keyed : this.provider) {
            Object object = keyed.value();
            if (object instanceof StaticPlaceholder) {
                StaticPlaceholder staticPlaceholder = (StaticPlaceholder)object;
                builder.audiencePlaceholder(keyed.key().value(), this.staticParser(staticPlaceholder));
                continue;
            }
            object = keyed.value();
            if (!(object instanceof DynamicPlaceholder)) continue;
            DynamicPlaceholder dynamicPlaceholder = (DynamicPlaceholder)object;
            builder.audiencePlaceholder(keyed.key().value(), this.dynamicParser(dynamicPlaceholder));
        }
        ((Expansion)builder.build()).register();
    }

    private AudienceTagResolver<@NonNull Audience> staticParser(StaticPlaceholder placeholder) {
        return (audience, queue, ctx) -> this.parse(audience, placeholder);
    }

    private AudienceTagResolver<@NonNull Audience> dynamicParser(DynamicPlaceholder placeholder) {
        return (audience, queue, ctx) -> !queue.hasNext() ? Tags.EMPTY_TAG : this.parse(audience, u -> placeholder.handle((User)u, queue.pop().value()));
    }

    private Tag parse(Audience audience, Function<User, Component> placeholder) {
        return audience.pointers().get(Identity.UUID).flatMap(Registries.BENDERS::getIfExists).map(placeholder).map(Tag::selfClosingInserting).orElse(Tags.EMPTY_TAG);
    }
}

