/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.listener;

import bending.libraries.caffeine.cache.AsyncLoadingCache;
import bending.libraries.caffeine.cache.Caffeine;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.functional.Suppliers;
import me.moros.bending.common.logging.Logger;

public abstract class AbstractConnectionListener {
    private final Logger logger;
    protected final Supplier<Game> gameSupplier;
    protected final AsyncLoadingCache<UUID, BenderProfile> profileCache;

    protected AbstractConnectionListener(Logger logger, Game game) {
        this(logger, Suppliers.cached(game));
    }

    protected AbstractConnectionListener(Logger logger, Supplier<Game> gameSupplier) {
        this.logger = logger;
        this.gameSupplier = gameSupplier;
        this.profileCache = Caffeine.newBuilder().maximumSize(64L).executor(Executors.newVirtualThreadPerTaskExecutor()).expireAfterWrite(2L, TimeUnit.MINUTES).buildAsync(this::cacheLoad);
    }

    private Game game() {
        return this.gameSupplier.get();
    }

    private BenderProfile cacheLoad(UUID uuid) {
        BenderProfile profile = this.game().storage().loadProfile(uuid);
        return profile == null ? BenderProfile.of(uuid) : profile;
    }

    protected CompletableFuture<?> asyncJoin(UUID uuid) {
        if (BendingProperties.instance().lazyLoad() && this.game().storage().isRemote()) {
            return CompletableFuture.completedFuture(null);
        }
        long startTime = System.currentTimeMillis();
        return this.profileCache.get(uuid).orTimeout(1000L, TimeUnit.MILLISECONDS).whenComplete((ignore, t) -> {
            if (t == null) {
                long deltaTime = System.currentTimeMillis() - startTime;
                if (deltaTime > 500L) {
                    this.logger.warn("Processing login for %s took %dms".formatted(uuid, deltaTime));
                }
            } else if (t instanceof TimeoutException) {
                this.logger.warn("Timed out while retrieving data for %s".formatted(uuid));
            } else {
                this.logger.warn(t.getMessage(), (Throwable)t);
            }
        });
    }

    protected void syncJoin(UUID uuid, Supplier<Player> playerSupplier) {
        User.create(this.game(), (LivingEntity)playerSupplier.get(), this.profileCache.get(uuid));
    }

    protected void onQuit(UUID uuid) {
        Registries.BENDERS.getIfExists(uuid).ifPresent(this.game().activationController()::onUserDeconstruct);
        this.profileCache.synchronous().invalidate(uuid);
    }
}

