/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.locale;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import me.moros.bending.api.locale.Translation;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.util.Debounced;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationStore;
import net.kyori.adventure.translation.Translator;
import org.spongepowered.configurate.reference.WatchServiceListener;

public final class TranslationManager
implements Iterable<Locale> {
    private static final String PATH = "bending.lang.messages_en";
    private final Logger logger;
    private final Path translationsDirectory;
    private final Set<Locale> localeSet;
    private final AtomicReference<TranslationStore.StringBased<MessageFormat>> registryReference;
    private final Debounced<?> buffer;

    public TranslationManager(Logger logger, Path directory, WatchServiceListener listener) throws IOException {
        this.logger = logger;
        this.translationsDirectory = Files.createDirectories(directory.resolve("translations"), new FileAttribute[0]);
        this.localeSet = new CopyOnWriteArraySet<Locale>();
        this.registryReference = new AtomicReference<TranslationStore.StringBased<MessageFormat>>(this.createRegistry());
        GlobalTranslator.translator().addSource((Translator)this.registryReference.get());
        this.buffer = Debounced.create(this::reload, 2L, TimeUnit.SECONDS);
        listener.listenToDirectory(this.translationsDirectory, e -> this.refresh());
    }

    public void refresh() {
        this.buffer.request();
    }

    private void reload() {
        TranslationStore.StringBased<MessageFormat> newRegistry = this.createRegistry();
        TranslationStore.StringBased<MessageFormat> old = this.registryReference.getAndSet(newRegistry);
        GlobalTranslator.translator().removeSource(old);
        GlobalTranslator.translator().addSource(newRegistry);
        this.logger.info("Registered translations: " + TextUtil.collect(this.localeSet, Locale::getLanguage));
    }

    private TranslationStore.StringBased<MessageFormat> createRegistry() {
        this.localeSet.clear();
        TranslationStore.StringBased registry = TranslationStore.messageFormat((Key)KeyUtil.simple("translations"));
        registry.defaultLocale(Translation.DEFAULT_LOCALE);
        this.loadCustom((TranslationStore.StringBased<MessageFormat>)registry);
        this.loadDefaults((TranslationStore.StringBased<MessageFormat>)registry);
        this.loadFromRegistry((TranslationStore.StringBased<MessageFormat>)registry);
        return registry;
    }

    private void loadDefaults(TranslationStore.StringBased<MessageFormat> registry) {
        ResourceBundle bundle = ResourceBundle.getBundle(PATH, Translation.DEFAULT_LOCALE);
        this.registerBundle(registry, Translation.DEFAULT_LOCALE, bundle);
    }

    private void loadCustom(TranslationStore.StringBased<MessageFormat> registry) {
        List<Object> paths;
        try (Stream<Path> stream = Files.list(this.translationsDirectory);){
            paths = stream.filter(TranslationManager::isValidPropertyFile).toList();
        }
        catch (IOException e) {
            paths = List.of();
        }
        paths.forEach(path -> this.loadTranslationFile((Path)path, registry));
    }

    private void loadTranslationFile(Path path, TranslationStore.StringBased<MessageFormat> registry) {
        PropertyResourceBundle bundle;
        String localeString = TranslationManager.removeFileExtension(path);
        Locale locale = Translator.parseLocale((String)localeString);
        if (locale == null) {
            this.logger.warn("Unknown locale: " + localeString);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            bundle = new PropertyResourceBundle(reader);
        }
        catch (IOException e) {
            this.logger.warn("Error loading locale file: " + localeString);
            return;
        }
        this.registerBundle(registry, locale, bundle);
    }

    private void registerBundle(TranslationStore.StringBased<MessageFormat> registry, Locale locale, ResourceBundle bundle) {
        registry.registerAll(locale, bundle, false);
        this.localeSet.add(locale);
    }

    private void loadFromRegistry(TranslationStore.StringBased<MessageFormat> registry) {
        for (Translation translation : Registries.TRANSLATIONS) {
            Locale locale = translation.locale();
            this.localeSet.add(locale);
            for (Map.Entry<String, MessageFormat> entry : translation) {
                String key = entry.getKey();
                if (registry.contains(key)) continue;
                registry.register(key, locale, (Object)entry.getValue());
            }
        }
    }

    private static boolean isValidPropertyFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".properties");
    }

    private static String removeFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.substring(0, fileName.length() - ".properties".length());
    }

    @Override
    public Iterator<Locale> iterator() {
        return this.localeSet.iterator();
    }
}

