/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage;

import bending.libraries.flywaydb.core.Flyway;
import bending.libraries.jdbi.v3.core.Jdbi;
import bending.libraries.jdbi.v3.core.argument.AbstractArgumentFactory;
import bending.libraries.jdbi.v3.core.argument.Argument;
import bending.libraries.jdbi.v3.core.config.ConfigRegistry;
import bending.libraries.jdbi.v3.core.mapper.ColumnMapper;
import bending.libraries.jdbi.v3.core.statement.PreparedBatch;
import bending.libraries.jdbi.v3.core.statement.Query;
import bending.libraries.jdbi.v3.core.statement.StatementContext;
import bending.libraries.jdbi.v3.core.statement.Update;
import bending.libraries.storage.StorageDataSource;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.storage.AbstractStorage;
import me.moros.bending.common.storage.sql.PresetAccumulator;
import me.moros.bending.common.storage.sql.dialect.SqlDialect;
import me.moros.bending.common.storage.sql.migration.V1__Rename_legacy_tables;
import me.moros.bending.common.storage.sql.migration.V3__Migrate_from_legacy;
import me.moros.bending.common.util.UUIDUtil;
import net.kyori.adventure.util.Index;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SqlStorage
extends AbstractStorage {
    private final Index<UUID, AbilityDescription> abilityIndex;
    private final StorageDataSource dataSource;
    private final SqlDialect dialect;
    private final Jdbi DB;

    SqlStorage(Logger logger, StorageDataSource dataSource) {
        super(logger);
        this.dataSource = dataSource;
        this.dialect = SqlDialect.createFor(logger, dataSource);
        this.migrateWithFlyway();
        this.DB = Jdbi.create(this.dataSource.source());
        if (!this.dialect.nativeUuid()) {
            this.DB.registerArgument(new UUIDArgumentFactory());
            this.DB.registerColumnMapper((Type)((Object)UUID.class), (ColumnMapper<?>)new BinaryUUIDColumnMapper());
        }
        this.abilityIndex = this.createAbilities();
    }

    private void migrateWithFlyway() {
        Flyway flyway = Flyway.configure(this.getClass().getClassLoader()).table("bending_schemahistory").loggers("slf4j").locations("classpath:bending/migrations").javaMigrations(new V1__Rename_legacy_tables(), new V3__Migrate_from_legacy(this.logger, this.dialect.nativeUuid())).dataSource(this.dataSource.source()).validateOnMigrate(true).validateMigrationNaming(true).baselineOnMigrate(true).baselineVersion("0").placeholders(Map.of("extraTableOptions", this.dialect.extraTableOptions(), "uuidType", this.dialect.uuidType(), "defineElementEnumType", this.dialect.defineElementEnumType(), "elementEnumType", this.dialect.elementEnumType())).load();
        flyway.migrate();
    }

    private Index<UUID, AbilityDescription> createAbilities() {
        Map entries = this.DB.inTransaction(handle -> {
            Map<AbilityDescription, UUID> map = handle.createQuery("SELECT ability_id, ability_name FROM bending_abilities").map(this::abilityRowMapper).filter(Objects::nonNull).collectToMap(Map.Entry::getKey, Map.Entry::getValue);
            int size = map.size();
            PreparedBatch batch = handle.prepareBatch(this.dialect.insertAbilities());
            for (AbilityDescription desc : Registries.ABILITIES) {
                if (!desc.canBind() || map.containsKey(desc)) continue;
                UUID uuid = map.computeIfAbsent(desc, k -> UUID.randomUUID());
                ((PreparedBatch)((PreparedBatch)batch.bind(0, uuid)).bind(1, desc.key().asString())).add();
            }
            if (map.size() != size) {
                batch.execute();
            }
            return map;
        });
        return Index.create(entries::get, new ArrayList(entries.keySet()));
    }

    @Override
    public Set<UUID> loadUuids() {
        return this.DB.withHandle(handle -> handle.createQuery("SELECT user_id FROM bending_users").mapTo(UUID.class).set());
    }

    @Override
    public @Nullable BenderProfile loadProfile(UUID uuid) {
        Boolean board = this.DB.withHandle(handle -> ((Query)handle.createQuery("SELECT board FROM bending_users WHERE user_id = ? LIMIT 1").bind(0, uuid)).mapTo(Boolean.TYPE).findOne().orElse(null));
        if (board == null) {
            return null;
        }
        Set<Element> elements = this.getElements(uuid);
        Map<String, Preset> presetMap = this.getSlotsAndPresets(uuid);
        Preset slots = presetMap.remove("");
        if (slots == null) {
            slots = Preset.empty();
        }
        return BenderProfile.of(uuid, board, elements, slots, presetMap.values());
    }

    @Override
    public boolean saveProfile(BenderProfile profile) {
        this.saveBoard(profile);
        this.saveElements(profile);
        this.savePresets(profile);
        return true;
    }

    @Override
    public boolean isRemote() {
        return !this.dataSource.type().isLocal();
    }

    @Override
    public void close() {
        this.dataSource.source().close();
    }

    public String toString() {
        return this.dataSource.type().toString();
    }

    private Set<Element> getElements(UUID uuid) {
        return this.DB.withHandle(handle -> ((Query)handle.createQuery("SELECT element FROM bending_user_elements WHERE user_id = ?").bind(0, uuid)).mapTo(String.class).map(Element::fromName).filter(Objects::nonNull).toCollection(ElementSet::mutable));
    }

    private Map<String, Preset> getSlotsAndPresets(UUID uuid) {
        return this.DB.withHandle(handle -> ((Query)handle.createQuery("SELECT preset_name, slot, ability_id FROM bending_profiles WHERE user_id = ?").bind(0, uuid)).reduceRows(new PresetAccumulator(this::getAbilityFromId)).collect(Collectors.toMap(Preset::name, Function.identity())));
    }

    private void saveBoard(BenderProfile profile) {
        this.DB.useTransaction(handle -> ((Update)((Update)handle.createUpdate(this.dialect.insertUser()).bind(0, profile.uuid())).bind(1, profile.board())).execute());
    }

    private void saveElements(BenderProfile profile) {
        this.DB.useTransaction(handle -> {
            ((Update)handle.createUpdate("DELETE FROM bending_user_elements WHERE user_id = ?").bind(0, profile.uuid())).execute();
            if (!profile.elements().isEmpty()) {
                PreparedBatch batch = handle.prepareBatch("INSERT INTO bending_user_elements (user_id, element) VALUES (?, ?)");
                for (Element element : profile.elements()) {
                    ((PreparedBatch)((PreparedBatch)batch.bind(0, profile.uuid())).bind(1, element.name().toLowerCase(Locale.ROOT))).add();
                }
                batch.execute();
            }
        });
    }

    private void savePresets(BenderProfile profile) {
        UUID userId = profile.uuid();
        Collection<Preset> oldPresets = this.getSlotsAndPresets(userId).values();
        Collection<Preset> newPresets = profile.presets().values();
        HashSet<Preset> removed = new HashSet<Preset>(oldPresets);
        removed.removeAll(newPresets);
        removed.remove(profile.slots());
        HashSet<Preset> added = new HashSet<Preset>(newPresets);
        added.add(profile.slots());
        added.removeAll(oldPresets);
        added.removeIf(Preset::isEmpty);
        this.deletePresets(userId, removed);
        this.savePresets(userId, added);
    }

    private void savePresets(UUID userId, Collection<Preset> presets) {
        if (presets.isEmpty()) {
            return;
        }
        this.DB.useTransaction(handle -> {
            PreparedBatch presetBatch = handle.prepareBatch("INSERT INTO bending_presets (preset_id, user_id, preset_name) VALUES (?, ?, ?)");
            PreparedBatch presetSlotBatch = handle.prepareBatch("INSERT INTO bending_preset_slots (preset_id, slot, ability_id) VALUES (?, ?, ?)");
            for (Preset preset : presets) {
                UUID presetId = UUID.randomUUID();
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)presetBatch.bind(0, presetId)).bind(1, userId)).bind(2, preset.name())).add();
                preset.forEach((desc, idx) -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)presetSlotBatch.bind(0, presetId)).bind(1, idx + 1)).bind(2, (UUID)this.abilityIndex.key(desc))).add());
            }
            presetBatch.execute();
            presetSlotBatch.execute();
        });
    }

    private void deletePresets(UUID userId, Collection<Preset> presets) {
        if (presets.isEmpty()) {
            return;
        }
        this.DB.useTransaction(handle -> {
            PreparedBatch batch = handle.prepareBatch("DELETE FROM bending_presets WHERE user_id = ? AND preset_name = ?");
            for (Preset preset : presets) {
                ((PreparedBatch)((PreparedBatch)batch.bind(0, userId)).bind(1, preset.name())).add();
            }
            batch.execute();
        });
    }

    private @Nullable AbilityDescription getAbilityFromId(UUID uuid) {
        return (AbilityDescription)this.abilityIndex.value((Object)uuid);
    }

    private @Nullable Map.Entry<AbilityDescription, UUID> abilityRowMapper(ResultSet rs, StatementContext ctx) throws SQLException {
        AbilityDescription desc = Registries.ABILITIES.fromString(rs.getString("ability_name"));
        return desc == null ? null : Map.entry(desc, this.mapUuid(rs, "ability_id", ctx));
    }

    private UUID mapUuid(ResultSet rs, String column, StatementContext ctx) throws SQLException {
        return this.dialect.nativeUuid() ? rs.getObject(column, UUID.class) : ctx.findColumnMapperFor(UUID.class).orElseThrow().map(rs, column, ctx);
    }

    private static final class UUIDArgumentFactory
    extends AbstractArgumentFactory<UUID> {
        private UUIDArgumentFactory() {
            super(-2);
        }

        @Override
        protected Argument build(UUID value, ConfigRegistry config) {
            return (position, statement, ctx) -> statement.setBytes(position, UUIDUtil.toBytes(value));
        }
    }

    private static final class BinaryUUIDColumnMapper
    implements ColumnMapper<UUID> {
        private BinaryUUIDColumnMapper() {
        }

        @Override
        public @Nullable UUID map(ResultSet rs, int columnNumber, StatementContext ctx) throws SQLException {
            byte[] bytes = rs.getBytes(columnNumber);
            return bytes == null ? null : UUIDUtil.fromBytes(bytes);
        }
    }
}

