/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage;

import bending.libraries.storage.Builder;
import bending.libraries.storage.StorageDataSource;
import bending.libraries.storage.StorageType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.common.Bending;
import me.moros.bending.common.config.ConfigManager;
import me.moros.bending.common.storage.FileStorage;
import me.moros.bending.common.storage.SqlStorage;
import me.moros.bending.common.storage.StorageEngine;
import me.moros.bending.common.storage.file.loader.Loader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public record StorageFactory(Bending plugin) {
    public @Nullable BendingStorage createInstance() {
        Config config = ConfigManager.load(Config::new);
        return config.engine.loader().map(this::fileStorage).orElseGet(() -> this.sqlStorage(config));
    }

    private BendingStorage fileStorage(Loader<?> loader) {
        return new FileStorage(this.plugin.logger(), this.plugin.path().resolve("data").resolve("flatfile"), loader);
    }

    private @Nullable BendingStorage sqlStorage(Config config) {
        StorageDataSource data;
        StorageType storageType = config.engine.type().orElseThrow();
        Builder builder = StorageDataSource.builder(storageType).database(config.database).host(config.host).port(config.port).username(config.username).password(config.password);
        builder.configure(c -> {
            c.setMaximumPoolSize(config.poolSettings.maximumPoolSize);
            c.setMinimumIdle(config.poolSettings.minimumIdle);
            c.setMaxLifetime(config.poolSettings.maxLifetime);
            c.setKeepaliveTime(config.poolSettings.keepAliveTime);
            c.setConnectionTimeout(config.poolSettings.connectionTimeout);
        });
        if (storageType.isLocal()) {
            switch (storageType) {
                case HSQL: {
                    builder.properties(p -> {
                        p.put("sql.syntax_pgs", (Object)true);
                        p.put("hsqldb.default_table_type", "cached");
                    });
                    break;
                }
                case H2: {
                    builder.properties(p -> {
                        p.put("MODE", "PostgreSQL");
                        p.put("DB_CLOSE_ON_EXIT", (Object)false);
                    });
                }
            }
            Path parent = this.plugin.path().resolve("data").resolve(storageType.realName());
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.logger().error(e.getMessage(), e);
                return null;
            }
            builder.path(Path.of(parent.resolve("bending").toUri()));
        }
        return (data = builder.build("bending-hikari")) == null ? null : new SqlStorage(this.plugin.logger(), data);
    }

    private static final class Config
    implements Configurable {
        @Comment(value="Available options:\n- Remote:\n  > POSTGRESQL (preferred)\n  > MARIADB\n  > MYSQL\n- Local:\n  > H2 (preferred)\n  > HSQL\n  > JSON")
        private StorageEngine engine = StorageEngine.H2;
        private String host = "localhost";
        private int port = 5432;
        private String username = "bending";
        private String password = "password";
        private String database = "bending";
        private PoolSettings poolSettings = new PoolSettings();

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("storage");
        }
    }

    @ConfigSerializable
    private static final class PoolSettings {
        private int maximumPoolSize = 6;
        private int minimumIdle = 6;
        private int maxLifetime = 1800000;
        private int keepAliveTime = 0;
        private int connectionTimeout = 5000;

        private PoolSettings() {
        }
    }
}

