/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage.sql.dialect;

import bending.libraries.storage.StorageType;
import me.moros.bending.common.storage.sql.dialect.SqlDialect;

record SqlDialectImpl(StorageType type, boolean nativeUuidSupport) implements SqlDialect
{
    @Override
    public boolean nativeUuid() {
        return switch (this.type()) {
            case StorageType.POSTGRESQL, StorageType.H2, StorageType.HSQL -> true;
            case StorageType.MARIADB -> this.nativeUuidSupport;
            default -> false;
        };
    }

    @Override
    public String extraTableOptions() {
        return switch (this.type()) {
            case StorageType.MARIADB, StorageType.MYSQL -> " DEFAULT CHARSET = utf8mb4";
            default -> "";
        };
    }

    @Override
    public String defineElementEnumType() {
        return switch (this.type()) {
            case StorageType.POSTGRESQL, StorageType.H2 -> "CREATE TYPE bending_element AS ENUM ('air', 'water', 'earth', 'fire');";
            default -> "";
        };
    }

    @Override
    public String elementEnumType() {
        return switch (this.type()) {
            case StorageType.POSTGRESQL, StorageType.H2 -> "bending_element";
            default -> "ENUM('air','water','earth','fire')";
        };
    }

    private boolean pgInsert() {
        return this.type() == StorageType.H2 || this.type() == StorageType.POSTGRESQL;
    }

    @Override
    public String insertAbilities() {
        String insert = "INSERT INTO bending_abilities (ability_id, ability_name) VALUES (?, ?) ON ";
        return insert + (this.pgInsert() ? "CONFLICT DO NOTHING" : "DUPLICATE KEY UPDATE ability_name = ability_name");
    }

    @Override
    public String insertUser() {
        return this.pgInsert() ? "MERGE INTO bending_users (user_id, board) VALUES (?, ?)" : "INSERT INTO bending_users (user_id, board) VALUES (?, ?) ON DUPLICATE KEY UPDATE board = VALUES (board)";
    }
}

