/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage.sql.migration;

import bending.libraries.flywaydb.core.api.migration.BaseJavaMigration;
import bending.libraries.flywaydb.core.api.migration.Context;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.util.UUIDUtil;

public class V3__Migrate_from_legacy
extends BaseJavaMigration {
    private final Logger logger;
    private final boolean nativeUuid;

    public V3__Migrate_from_legacy(Logger logger, boolean nativeUuid) {
        this.logger = logger;
        this.nativeUuid = nativeUuid;
    }

    @Override
    public void migrate(Context context) throws Exception {
        Connection conn = context.getConnection();
        if (this.containsTable(conn, "bending_players")) {
            this.logger.info("Detected legacy database, attempting to migrate...");
            this.completeMigration(conn);
        }
    }

    private boolean containsTable(Connection connection, String tableName) throws Exception {
        try (ResultSet rs = connection.getMetaData().getTables(connection.getCatalog(), null, "%", null);){
            while (rs.next()) {
                if (!rs.getString(3).equalsIgnoreCase(tableName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void completeMigration(Connection connection) throws Exception {
        UUID presetId;
        Map userPresets;
        UUID userId;
        PreparedStatement prepared;
        HashMap<String, UUID> abilities = new HashMap<String, UUID>(64);
        try (Statement statement = connection.createStatement();){
            statement.execute(this.migratePlayers());
            statement.execute(this.migratePlayerElements());
            ResultSet rs = statement.executeQuery(this.selectAbilitiesOld());
            while (rs.next()) {
                abilities.put(rs.getString("ability_name"), UUID.randomUUID());
            }
            if (!abilities.isEmpty()) {
                prepared = connection.prepareStatement(this.insertAbilities());
                for (Map.Entry entry : abilities.entrySet()) {
                    this.bind(prepared, 1, (UUID)entry.getValue());
                    prepared.setString(2, (String)entry.getKey());
                    prepared.addBatch();
                }
                prepared.executeBatch();
            }
        }
        Map<UUID, Map<String, String[]>> presets = this.loadPresets(connection);
        HashMap<UUID, Map> presetIds = new HashMap<UUID, Map>(presets.size());
        prepared = connection.prepareStatement(this.insertPresets());
        try {
            for (Map.Entry<Object, Object> entry : presets.entrySet()) {
                userId = (UUID)entry.getKey();
                userPresets = (Map)entry.getValue();
                for (String string : userPresets.keySet()) {
                    presetId = UUID.randomUUID();
                    presetIds.computeIfAbsent(userId, k -> new HashMap()).put(string, presetId);
                    this.bind(prepared, 1, presetId);
                    this.bind(prepared, 2, userId);
                    prepared.setString(3, string);
                    prepared.addBatch();
                }
            }
            prepared.executeBatch();
        }
        finally {
            if (prepared != null) {
                prepared.close();
            }
        }
        prepared = connection.prepareStatement(this.insertPresetSlots());
        try {
            for (Map.Entry<Object, Object> entry : presets.entrySet()) {
                userId = (UUID)entry.getKey();
                userPresets = (Map)entry.getValue();
                for (Map.Entry entry2 : userPresets.entrySet()) {
                    presetId = (UUID)((Map)presetIds.get(userId)).get(entry2.getKey());
                    String[] presetAbilities = (String[])entry2.getValue();
                    for (int i = 0; i < presetAbilities.length; ++i) {
                        UUID abilityId;
                        String ability = presetAbilities[i];
                        UUID uUID = abilityId = ability == null ? null : (UUID)abilities.get(ability);
                        if (abilityId == null) continue;
                        this.bind(prepared, 1, presetId);
                        prepared.setShort(2, (short)(i + 1));
                        this.bind(prepared, 3, abilityId);
                        prepared.addBatch();
                    }
                }
            }
            prepared.executeBatch();
        }
        finally {
            if (prepared != null) {
                prepared.close();
            }
        }
        try (Statement statement = connection.createStatement();){
            statement.execute(this.cleanupTables());
        }
    }

    private String migratePlayers() {
        return "INSERT INTO bending_users (user_id, board) SELECT player_uuid, board FROM bending_players;";
    }

    private String selectAbilitiesOld() {
        return "SELECT ability_name FROM bending_abilities_old;";
    }

    private String insertAbilities() {
        return "INSERT INTO bending_abilities (ability_id, ability_name) VALUES (?, ?)";
    }

    private String migratePlayerElements() {
        return "INSERT INTO bending_user_elements (user_id, element)\nSELECT temp.player_uuid AS user_id, old.element\nFROM bending_players_elements old\nINNER JOIN bending_players temp ON old.player_id = temp.player_id;\n";
    }

    private Map<UUID, Map<String, String[]>> loadPresets(Connection connection) throws Exception {
        HashMap<UUID, Map<String, String[]>> result = new HashMap<UUID, Map<String, String[]>>(256);
        try (Statement statement = connection.createStatement();){
            UUID uuid;
            ResultSet rs = statement.executeQuery(this.loadPresets());
            while (rs.next()) {
                uuid = this.mapUuid(rs, "player_uuid");
                String name = rs.getString("preset_name");
                String[] presetSlots = result.computeIfAbsent(uuid, k -> new HashMap()).computeIfAbsent(name, k -> new String[9]);
                int slot = rs.getInt("slot") - 1;
                if (slot < 0 || slot >= presetSlots.length) continue;
                presetSlots[slot] = rs.getString("ability_name");
            }
            rs = statement.executeQuery(this.loadSlots());
            while (rs.next()) {
                uuid = this.mapUuid(rs, "player_uuid");
                String[] presetSlots = result.computeIfAbsent(uuid, k -> new HashMap()).computeIfAbsent("", k -> new String[9]);
                int slot = rs.getInt("slot") - 1;
                if (slot < 0 || slot >= presetSlots.length) continue;
                presetSlots[slot] = rs.getString("ability_name");
            }
        }
        return result;
    }

    private String loadPresets() {
        return "SELECT old.player_uuid, presets.preset_name, preset_slots.slot, abilities.ability_name\nFROM bending_players old\nINNER JOIN bending_presets_old presets ON old.player_id = presets.player_id\nINNER JOIN bending_presets_slots preset_slots ON presets.preset_id = preset_slots.preset_id\nINNER JOIN bending_abilities_old abilities ON preset_slots.ability_id = abilities.ability_id;\n";
    }

    private String loadSlots() {
        return "SELECT old.player_uuid, slots.slot, abilities.ability_name\nFROM bending_players old\nINNER JOIN bending_players_slots slots ON old.player_id = slots.player_id\nINNER JOIN bending_abilities_old abilities ON slots.ability_id = abilities.ability_id;\n";
    }

    private String insertPresets() {
        return "INSERT INTO bending_presets (preset_id, user_id, preset_name) VALUES (?, ?, ?)";
    }

    private String insertPresetSlots() {
        return "INSERT INTO bending_preset_slots (preset_id, slot, ability_id) VALUES (?, ?, ?)";
    }

    private String cleanupTables() {
        return "DROP TABLE bending_players_elements, bending_presets_slots, bending_presets_old, bending_players_slots, bending_abilities_old, bending_players CASCADE;";
    }

    private void bind(PreparedStatement prepared, int idx, UUID uuid) throws SQLException {
        if (this.nativeUuid) {
            prepared.setObject(idx, uuid);
        } else {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
            buffer.putLong(uuid.getMostSignificantBits());
            buffer.putLong(uuid.getLeastSignificantBits());
            prepared.setBytes(idx, buffer.array());
        }
    }

    private UUID mapUuid(ResultSet rs, String column) throws SQLException {
        return this.nativeUuid ? rs.getObject(column, UUID.class) : UUIDUtil.fromBytes(rs.getBytes(column));
    }
}

