/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.util;

import java.lang.reflect.Method;
import me.moros.bending.api.GameProvider;
import me.moros.bending.api.game.Game;

public final class GameProviderUtil {
    private static final Method REGISTER;
    private static final Method UNREGISTER;

    private GameProviderUtil() {
    }

    public static void registerProvider(Game game) {
        try {
            REGISTER.invoke(null, game);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unregisterProvider() {
        try {
            UNREGISTER.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            REGISTER = GameProvider.class.getDeclaredMethod("register", Game.class);
            REGISTER.setAccessible(true);
            UNREGISTER = GameProvider.class.getDeclaredMethod("unregister", new Class[0]);
            UNREGISTER.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

