/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.util.FeaturePermissions;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.util.TriState;

public abstract class PermissionInitializer
implements Initializer {
    protected PermissionInitializer() {
    }

    @Override
    public void init() {
        this.initPlayerNodes();
        this.initAdminNodes();
        this.initMisc();
    }

    private void initPlayerNodes() {
        Collection<String> elementNodes = this.initAbilityNodes();
        Set<String> children = Stream.of(Permissions.BIND, Permissions.BOARD, Permissions.CHOOSE, Permissions.HELP, Permissions.PRESET, Permissions.TOGGLE, Permissions.VERSION).collect(Collectors.toSet());
        children.addAll(elementNodes);
        children.add(FeaturePermissions.BOARD);
        children.add("bending.ability.avatarstate");
        this.registerDefault("bending.player", children);
    }

    private void initAdminNodes() {
        Set<String> children = Stream.of(Permissions.ADD, Permissions.REMOVE, Permissions.MODIFY, Permissions.RELOAD, Permissions.IMPORT, Permissions.EXPORT, Permissions.ATTRIBUTE).collect(Collectors.toSet());
        children.add("bending.player");
        children.add(FeaturePermissions.BLUE_FIRE);
        children.add(Permissions.CHOOSE + ".other");
        children.add(Permissions.ADD + ".other");
        children.add(Permissions.REMOVE + ".other");
        this.registerDefault("bending.admin", children, TriState.NOT_SET);
    }

    private void initMisc() {
    }

    private Collection<String> initAbilityNodes() {
        return List.of(this.registerAbilityNodes(Element.AIR), this.registerAbilityNodes(Element.WATER), this.registerAbilityNodes(Element.EARTH), this.registerAbilityNodes(Element.FIRE));
    }

    private String registerAbilityNodes(Element element) {
        String node = this.elementParentNode(element);
        Collection<String> abilityNodes = this.collect(element);
        abilityNodes.add(Permissions.CHOOSE + "." + element.toString().toLowerCase(Locale.ROOT));
        this.registerDefault(node, abilityNodes);
        return node;
    }

    private String elementParentNode(Element element) {
        return "bending." + element.key().value();
    }

    private Collection<String> collect(Element element) {
        ElementSet singleElementSet = ElementSet.of(element);
        return Registries.ABILITIES.stream().filter(a -> singleElementSet.equals(a.elements())).map(AbilityDescription::permissions).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected void registerDefault(String node, Collection<String> children) {
        this.registerDefault(node, children, TriState.TRUE);
    }

    protected abstract void registerDefault(String var1, Collection<String> var2, TriState var3);
}

