/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.util;

import java.util.List;
import java.util.function.Function;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.entity.player.GameMode;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemTag;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.potion.PotionEffectTag;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.registry.TagBuilder;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.common.util.ReflectionUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;

public interface RegistryInitializer
extends Initializer {
    @Override
    default public void init() {
        List<Sound> dummy = List.of(BlockType.AIR, BlockTag.DIRT, EntityType.PLAYER, GameMode.SURVIVAL, Item.AIR, ItemTag.DIRT, Particle.FLAME, PotionEffect.INSTANT_HEALTH, Sound.BLOCK_FIRE_AMBIENT);
        dummy.forEach(Keyed::key);
        this.initEntityTypeRegistry(EntityType.registry());
        this.initParticleRegistry(Particle.registry());
        this.initSoundRegistry(Sound.registry());
        this.initPotionEffectRegistry(PotionEffect.registry());
        this.initPotionEffectTagRegistry(PotionEffect.registry(), PotionEffectTag::builder);
        this.initItemRegistry(Item.registry());
        this.initItemTagRegistry(Item.registry(), ItemTag::builder);
        Class<?> clazz = ReflectionUtil.getClassOrThrow("me.moros.bending.api.platform.block.BlockTypeImpl");
        Registry propertyRegistry = (Registry)ReflectionUtil.getStaticFieldOrThrow(clazz, "PROPERTY_REGISTRY");
        Registry stateRegistry = (Registry)ReflectionUtil.getStaticFieldOrThrow(clazz, "STATE_REGISTRY");
        Registry itemRegistry = (Registry)ReflectionUtil.getStaticFieldOrThrow(clazz, "ITEM_REGISTRY");
        this.initBlockTypeRegistry(BlockType.registry(), propertyRegistry, stateRegistry, itemRegistry);
        this.initBlockTypeTagRegistry(BlockType.registry(), BlockTag::builder);
        MaterialUtil.init();
        EarthMaterials.init();
        WaterMaterials.init();
    }

    public void initBlockTypeRegistry(Registry<Key, BlockType> var1, Registry<Key, BlockProperties> var2, Registry<Key, BlockState> var3, Registry<Key, Item> var4);

    public void initBlockTypeTagRegistry(Registry<Key, BlockType> var1, Function<Key, TagBuilder<BlockType, BlockTag>> var2);

    public void initEntityTypeRegistry(Registry<Key, EntityType> var1);

    public void initItemRegistry(Registry<Key, Item> var1);

    public void initItemTagRegistry(Registry<Key, Item> var1, Function<Key, TagBuilder<Item, ItemTag>> var2);

    public void initParticleRegistry(Registry<Key, Particle> var1);

    public void initPotionEffectRegistry(Registry<Key, PotionEffect> var1);

    public void initPotionEffectTagRegistry(Registry<Key, PotionEffect> var1, Function<Key, TagBuilder<PotionEffect, PotionEffectTag>> var2);

    public void initSoundRegistry(Registry<Key, Sound> var1);
}

