/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import me.moros.bending.api.addon.Addon;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.api.util.functional.Suppliers;
import me.moros.bending.common.AbstractBending;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.hook.LuckPermsHook;
import me.moros.bending.common.hook.MiniPlaceholdersHook;
import me.moros.bending.common.logging.Slf4jLogger;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.common.util.ReflectionUtil;
import me.moros.bending.fabric.game.DummyGame;
import me.moros.bending.fabric.hook.PlaceholderHook;
import me.moros.bending.fabric.listener.BlockListener;
import me.moros.bending.fabric.listener.ConnectionListener;
import me.moros.bending.fabric.listener.UserListener;
import me.moros.bending.fabric.listener.WorldListener;
import me.moros.bending.fabric.platform.BrigadierSetup;
import me.moros.bending.fabric.platform.CommandSender;
import me.moros.bending.fabric.platform.FabricMetadata;
import me.moros.bending.fabric.platform.FabricPermissionInitializer;
import me.moros.bending.fabric.platform.FabricPlatform;
import me.moros.tasker.fabric.FabricExecutor;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.fabric.FabricServerCommandManager;
import org.slf4j.LoggerFactory;

final class FabricBending
extends AbstractBending<ModContainer> {
    private LoadPhase phase = LoadPhase.FIRST;
    private final Collection<Initializer> listeners;
    private final AtomicBoolean exiting = new AtomicBoolean();

    FabricBending(ModContainer container, Path path) {
        super(container, path, new Slf4jLogger(LoggerFactory.getLogger((String)container.getMetadata().getName())));
        this.injectTasker(new FabricExecutor());
        Tasker.async().repeat(FabricMetadata.INSTANCE::removeEmpty, 5L, TimeUnit.MINUTES);
        this.listeners = List.of(new BlockListener(this::game), new UserListener(this::game), new ConnectionListener(this.logger(), this::game), new WorldListener(this::game));
        this.registerLifecycleListeners();
        FabricServerCommandManager manager = new FabricServerCommandManager(ExecutionCoordinator.simpleCoordinator(), SenderMapper.create(CommandSender::from, CommandSender::stack));
        BrigadierSetup.setup(manager);
        Commander.create(manager, CommandSender.PlayerCommandSender.class, this).init();
    }

    private void registerLifecycleListeners() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::onEnable);
        ServerLifecycleEvents.SERVER_STOPPING.register(s -> this.onDisable(this.exiting.get() || s.method_3816()));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientLifecycleEvents.CLIENT_STOPPING.register(m -> this.exiting.set(true));
        }
        new FabricPermissionInitializer().init();
    }

    private void onEnable(MinecraftServer server) {
        if (this.phase == LoadPhase.FIRST) {
            this.listeners.forEach(Initializer::init);
            this.registerAddonProviders();
            this.registerHooks();
            this.phase = LoadPhase.LOADING;
        }
        if (this.phase == LoadPhase.LOADING) {
            ReflectionUtil.injectStatic(Platform.Holder.class, new FabricPlatform(server));
            this.load();
            this.phase = LoadPhase.LOADED;
        }
    }

    private void onDisable(boolean fullShutdown) {
        if (this.phase == LoadPhase.LOADED) {
            FabricMetadata.INSTANCE.cleanup();
            if (fullShutdown) {
                this.disable();
            } else {
                this.softDisable();
            }
            this.phase = LoadPhase.LOADING;
        }
    }

    private void registerHooks() {
        if (FabricLoader.getInstance().isModLoaded("placeholder-api")) {
            new PlaceholderHook().init();
        }
        if (FabricLoader.getInstance().isModLoaded("miniplaceholders")) {
            new MiniPlaceholdersHook().init();
        }
        if (FabricLoader.getInstance().isModLoaded("luckperms")) {
            LuckPermsHook<class_3222> hook = LuckPermsHook.register(class_1297::method_5667);
            this.registerNamedAddon("preset-limits", hook::presetLimits);
        }
    }

    private Game game() {
        return this.game != null ? this.game : DummyGame.INSTANCE;
    }

    @Override
    public String author() {
        return ((ModContainer)this.parent).getMetadata().getAuthors().stream().map(Person::getName).findFirst().orElse("Moros");
    }

    @Override
    public String version() {
        return ((ModContainer)this.parent).getMetadata().getVersion().getFriendlyString();
    }

    private void registerAddonProviders() {
        FabricLoader.getInstance().getEntrypointContainers("bending", Addon.class).forEach(c -> this.registerNamedAddon(c.getProvider().getMetadata().getId(), Suppliers.lazy(() -> ((EntrypointContainer)c).getEntrypoint())));
    }

    private static enum LoadPhase {
        FIRST,
        LOADING,
        LOADED;

    }
}

