/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.event;

import me.moros.math.Vector3d;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_239;

public final class ServerEntityEvents {
    public static final Event<Merge> MERGE = EventFactory.createArrayBacked(Merge.class, callbacks -> (first, second) -> {
        for (Merge callback : callbacks) {
            if (callback.onMerge(first, second)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Damage> DAMAGE = EventFactory.createArrayBacked(Damage.class, callbacks -> (entity, source, damage) -> {
        double value = damage;
        for (Damage callback : callbacks) {
            if (!((value = callback.onDamage(entity, source, value)) <= 0.0)) continue;
            return 0.0;
        }
        return value;
    });
    public static final Event<EntityMove> ENTITY_MOVE = EventFactory.createArrayBacked(EntityMove.class, callbacks -> (entity, from, to) -> {
        for (EntityMove callback : callbacks) {
            if (callback.onMove(entity, from, to)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Target> TARGET = EventFactory.createArrayBacked(Target.class, callbacks -> (entity, target) -> {
        for (Target callback : callbacks) {
            if (callback.onEntityTarget(entity, target)) continue;
            return false;
        }
        return true;
    });
    public static final Event<ProjectileHit> PROJECTILE_HIT = EventFactory.createArrayBacked(ProjectileHit.class, callbacks -> (projectile, hitResult) -> {
        for (ProjectileHit callback : callbacks) {
            if (callback.onProjectileHit(projectile, hitResult)) continue;
            return false;
        }
        return true;
    });

    private ServerEntityEvents() {
    }

    @FunctionalInterface
    public static interface ProjectileHit {
        public boolean onProjectileHit(class_1676 var1, class_239 var2);
    }

    @FunctionalInterface
    public static interface Target {
        public boolean onEntityTarget(class_1309 var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface EntityMove {
        public boolean onMove(class_1309 var1, Vector3d var2, Vector3d var3);
    }

    @FunctionalInterface
    public static interface Damage {
        public double onDamage(class_1309 var1, class_1282 var2, double var3);
    }

    @FunctionalInterface
    public static interface Merge {
        public boolean onMerge(class_1542 var1, class_1542 var2);
    }
}

