/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public final class ServerPlayerEvents {
    public static final Event<Interact> INTERACT = EventFactory.createArrayBacked(Interact.class, callbacks -> (player, hand) -> {
        for (Interact callback : callbacks) {
            class_1269 result = callback.onInteract(player, hand);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    });
    public static final Event<Sneak> TOGGLE_SNEAK = EventFactory.createArrayBacked(Sneak.class, callbacks -> (player, sneaking) -> {
        for (Sneak callback : callbacks) {
            if (callback.onSneak(player, sneaking)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Sprint> TOGGLE_SPRINT = EventFactory.createArrayBacked(Sprint.class, callbacks -> (player, sprinting) -> {
        for (Sprint callback : callbacks) {
            if (callback.onSprint(player, sprinting)) continue;
            return false;
        }
        return true;
    });
    public static final Event<GameMode> CHANGE_GAMEMODE = EventFactory.createArrayBacked(GameMode.class, callbacks -> (player, newGameMode) -> {
        for (GameMode callback : callbacks) {
            callback.onGameModeChange(player, newGameMode);
        }
    });
    public static final Event<ChangeHeldSlot> CHANGE_SLOT = EventFactory.createArrayBacked(ChangeHeldSlot.class, callbacks -> (player, oldSlot, newSlot) -> {
        for (ChangeHeldSlot callback : callbacks) {
            callback.onHeldSlotChange(player, oldSlot, newSlot);
        }
    });
    public static final Event<ModifyInventorySlot> MODIFY_INVENTORY_SLOT = EventFactory.createArrayBacked(ModifyInventorySlot.class, callbacks -> (player, item) -> {
        for (ModifyInventorySlot callback : callbacks) {
            if (callback.onModify(player, item)) continue;
            return false;
        }
        return true;
    });
    public static final Event<PlaceBlock> PLACE_BLOCK = EventFactory.createArrayBacked(PlaceBlock.class, callbacks -> (player, pos, state) -> {
        for (PlaceBlock callback : callbacks) {
            if (callback.onPlace(player, pos, state)) continue;
            return false;
        }
        return true;
    });

    private ServerPlayerEvents() {
    }

    @FunctionalInterface
    public static interface PlaceBlock {
        public boolean onPlace(class_3222 var1, class_2338 var2, class_2680 var3);
    }

    @FunctionalInterface
    public static interface ModifyInventorySlot {
        public boolean onModify(class_3222 var1, class_1799 var2);
    }

    @FunctionalInterface
    public static interface ChangeHeldSlot {
        public void onHeldSlotChange(class_3222 var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface GameMode {
        public void onGameModeChange(class_3222 var1, class_1934 var2);
    }

    @FunctionalInterface
    public static interface Sprint {
        public boolean onSprint(class_3222 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Sneak {
        public boolean onSneak(class_3222 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Interact {
        public class_1269 onInteract(class_3222 var1, class_1268 var2);
    }
}

