/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.listener;

import java.util.List;
import java.util.function.Supplier;
import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.fabric.event.ServerBlockEvents;
import me.moros.bending.fabric.event.ServerPlayerEvents;
import me.moros.bending.fabric.listener.FabricListener;
import me.moros.bending.fabric.platform.PlatformAdapter;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public record BlockListener(Supplier<Game> gameSupplier) implements FabricListener,
Initializer
{
    @Override
    public void init() {
        ServerPlayerEvents.PLACE_BLOCK.register(this::onBlockPlace);
        ServerBlockEvents.AFTER_BREAK.register(this::onAfterBlockBreak);
        ServerBlockEvents.BLOCK_DROP_LOOT.register(this::onBlockDropLoot);
        ServerBlockEvents.CHANGE.register(this::onBlockChange);
        ServerBlockEvents.SPREAD.register(this::onBlockSpread);
        ServerBlockEvents.PISTON.register(this::onBlockPistonEvent);
    }

    private boolean onBlockPlace(class_3222 player, class_2338 pos, class_2680 state) {
        if (!this.disabledWorld((class_1297)player)) {
            if (ActionLimiter.isLimited(player.method_5667(), ActionType.INTERACT_BLOCK)) {
                return false;
            }
            Block block = PlatformAdapter.fromFabricWorld(player.method_51469()).blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
            TempBlock.MANAGER.get(block).ifPresent(TempBlock::removeWithoutReverting);
        }
        return true;
    }

    private boolean onAfterBlockBreak(class_3218 level, class_2338 pos) {
        Block block;
        TempBlock tb;
        if (!this.disabledWorld(level) && (tb = (TempBlock)TempBlock.MANAGER.get(block = PlatformAdapter.fromFabricWorld(level).blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260())).orElse(null)) != null) {
            tb.removeWithoutReverting();
            return false;
        }
        return true;
    }

    private boolean onBlockDropLoot(class_3218 level, class_2338 pos) {
        if (!this.disabledWorld(level)) {
            Block block = PlatformAdapter.fromFabricWorld(level).blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
            return !TempBlock.MANAGER.isTemp(block);
        }
        return true;
    }

    private boolean onBlockChange(class_3218 level, class_2338 pos) {
        if (!this.disabledWorld(level)) {
            Block block = PlatformAdapter.fromFabricWorld(level).blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
            return !TempBlock.MANAGER.isTemp(block);
        }
        return true;
    }

    private boolean onBlockSpread(class_3218 level, class_2338 pos, class_2338 pos2) {
        if (!this.disabledWorld(level)) {
            World world = PlatformAdapter.fromFabricWorld(level);
            Block block1 = world.blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
            Block block2 = world.blockAt(pos2.method_10263(), pos2.method_10264(), pos2.method_10260());
            return !TempBlock.MANAGER.isTemp(block1) && !TempBlock.MANAGER.isTemp(block2);
        }
        return true;
    }

    private boolean onBlockPistonEvent(class_3218 level, class_2338 pos, List<class_2338> toMove, List<class_2338> toDestroy) {
        if (!this.disabledWorld(level)) {
            World world = PlatformAdapter.fromFabricWorld(level);
            for (class_2338 bp : toMove) {
                if (!TempBlock.MANAGER.isTemp(world.blockAt(bp.method_10263(), bp.method_10264(), bp.method_10260()))) continue;
                return false;
            }
            for (class_2338 bp : toDestroy) {
                if (!TempBlock.MANAGER.isTemp(world.blockAt(bp.method_10263(), bp.method_10264(), bp.method_10260()))) continue;
                return false;
            }
        }
        return true;
    }
}

