/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.listener;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import me.moros.bending.api.game.Game;
import me.moros.bending.common.listener.AbstractConnectionListener;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.fabric.mixin.accessor.ServerLoginPacketListenerImplAccess;
import me.moros.bending.fabric.platform.entity.FabricPlayer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;

public final class ConnectionListener
extends AbstractConnectionListener
implements Initializer {
    public ConnectionListener(Logger logger, Supplier<Game> gameSupplier) {
        super(logger, gameSupplier);
    }

    @Override
    public void init() {
        ServerLoginConnectionEvents.QUERY_START.register(this::onPlayerPreLogin);
        ServerPlayerEvents.JOIN.register(this::onPlayerJoin);
        ServerPlayerEvents.LEAVE.register(this::onPlayerLeave);
    }

    private void onPlayerPreLogin(class_3248 handler, MinecraftServer server, PacketSender sender, ServerLoginNetworking.LoginSynchronizer synchronizer) {
        GameProfile prof = ((ServerLoginPacketListenerImplAccess)handler).bending$profile();
        if (prof != null) {
            synchronizer.waitFor(this.asyncJoin(prof.id()));
        }
    }

    private void onPlayerJoin(class_3222 player) {
        this.syncJoin(player.method_5667(), () -> new FabricPlayer(player));
    }

    private void onPlayerLeave(class_3222 player) {
        this.onQuit(player.method_5667());
    }
}

