/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.listener;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.Lockable;
import me.moros.bending.api.platform.damage.DamageCause;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempArmor;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.metadata.BlockInteraction;
import me.moros.bending.api.util.metadata.EntityInteraction;
import me.moros.bending.api.util.metadata.Metadata;
import me.moros.bending.common.ability.earth.EarthGlove;
import me.moros.bending.common.ability.earth.MetalCable;
import me.moros.bending.common.ability.earth.passive.Locksmithing;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.fabric.event.ServerEntityEvents;
import me.moros.bending.fabric.event.ServerInventoryEvents;
import me.moros.bending.fabric.event.ServerItemEvents;
import me.moros.bending.fabric.event.ServerPlayerEvents;
import me.moros.bending.fabric.listener.FabricListener;
import me.moros.bending.fabric.platform.FabricMetadata;
import me.moros.bending.fabric.platform.PlatformAdapter;
import me.moros.bending.fabric.platform.item.ItemUtil;
import me.moros.math.Vector3d;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.checkerframework.checker.nullness.qual.Nullable;

public record UserListener(Supplier<Game> gameSupplier) implements FabricListener,
Initializer
{
    @Override
    public void init() {
        net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents.COPY_FROM.register(this::onPlayerRespawn);
        ServerEntityEvents.PROJECTILE_HIT.register(this::onArrowHit);
        ServerEntityEvents.ENTITY_MOVE.register(this::onUserMove);
        ServerPlayerEvents.INTERACT.register(this::onLeftClickAir);
        ServerPlayerEvents.TOGGLE_SNEAK.register(this::onUserSneak);
        ServerPlayerEvents.TOGGLE_SPRINT.register(this::onUserSprint);
        EntityElytraEvents.CUSTOM.register(this::onUserGlide);
        AttackBlockCallback.EVENT.register(this::onLeftClickBlock);
        UseBlockCallback.EVENT.register(this::onRightClickBlock);
        UseItemCallback.EVENT.register(this::onRightClickAir);
        UseEntityCallback.EVENT.register(this::onRightClickEntity);
        ServerPlayerEvents.CHANGE_GAMEMODE.register(this::onUserGameModeChange);
        ServerPlayerEvents.CHANGE_SLOT.register(this::onHeldSlotChange);
        ServerEntityEvents.MERGE.register(this::onItemMerge);
        ServerEntityEvents.TARGET.register(this::onEntityTarget);
        ServerPlayerEvents.MODIFY_INVENTORY_SLOT.register(this::onInventoryClick);
        ServerInventoryEvents.HOPPER.register(this::onHopperItemPickup);
        ServerItemEvents.DROP_ITEM.register(this::onDropItem);
        ServerItemEvents.ACCESS_LOCK.register(this::onAccessLock);
        ServerEntityEvents.DAMAGE.register(this::onEntityDamage);
        ServerLivingEntityEvents.ALLOW_DAMAGE.register(this::onEntityAllowDamage);
        ServerLivingEntityEvents.AFTER_DEATH.register(this::onUserDeath);
        net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents.ENTITY_UNLOAD.register(this::onEntityUnload);
    }

    private boolean validGameMode(class_3222 player) {
        return player.field_13974.method_14257() != class_1934.field_9219;
    }

    private void onPlayerRespawn(class_1297 originalEntity, class_1297 newEntity, boolean alive) {
        User user = (User)Registries.BENDERS.get(originalEntity.method_5667());
        if (user != null) {
            PlatformAdapter.toFabricEntityWrapper(user).setHandle(newEntity);
        }
    }

    private boolean onArrowHit(class_1676 projectile, class_239 hitResult) {
        Optional<MetalCable> data;
        if (!this.disabledWorld((class_1297)projectile) && projectile instanceof class_1667 && (data = FabricMetadata.INSTANCE.metadata((class_1297)projectile).get(MetalCable.CABLE_KEY)).isPresent()) {
            MetalCable cable = data.get();
            if (hitResult instanceof class_3965) {
                class_3965 blockHit = (class_3965)hitResult;
                class_2338 pos = blockHit.method_17777();
                World world = PlatformAdapter.fromFabricWorld((class_3218)projectile.method_73183());
                cable.hitBlock(world.blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()));
            } else {
                class_3966 entityHit;
                class_1297 class_12972;
                if (hitResult instanceof class_3966 && (class_12972 = (entityHit = (class_3966)hitResult).method_17782()) instanceof class_1309) {
                    class_1309 living = (class_1309)class_12972;
                    cable.hitEntity(PlatformAdapter.fromFabricEntity(living));
                    return false;
                }
                projectile.method_31472();
            }
        }
        return true;
    }

    private boolean onUserMove(class_1309 entity, Vector3d from, Vector3d to) {
        if (!this.disabledWorld((class_1297)entity)) {
            if (!from.toVector3i().equals(to.toVector3i()) && ActionLimiter.isLimited(entity.method_5667(), ActionType.MOVE)) {
                return false;
            }
            User user = (User)Registries.BENDERS.get(entity.method_5667());
            if (user != null) {
                this.game().activationController().onUserMove(user, (Vector3d)((Vector3d)to.subtract(from)).withY(0.0));
            }
        }
        return true;
    }

    private class_1269 onLeftClickAir(class_3222 player, class_1268 hand) {
        return this.onUserSwing(player, hand);
    }

    private class_1269 onLeftClickBlock(class_1657 playerEntity, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        if (!world.method_8608() && playerEntity instanceof class_3222) {
            class_3222 player = (class_3222)playerEntity;
            return this.onUserSwing(player, hand);
        }
        return class_1269.field_5811;
    }

    private class_1269 onUserSwing(class_3222 player, class_1268 hand) {
        User user;
        if (this.validGameMode(player) && hand != class_1268.field_5810 && !this.disabledWorld((class_1297)player) && (user = (User)Registries.BENDERS.get(player.method_5667())) != null) {
            this.game().activationController().onUserSwing(user);
        }
        return class_1269.field_5811;
    }

    private class_1269 onRightClickBlock(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (hand == class_1268.field_5808 && !world.method_8608() && playerEntity instanceof class_3222) {
            class_3222 player = (class_3222)playerEntity;
            class_2338 pos = blockHitResult.method_17777();
            Block block = PlatformAdapter.fromFabricWorld(player.method_51469()).blockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
            class_243 loc = blockHitResult.method_17784();
            Vector3d point = Vector3d.of(loc.method_10216(), loc.method_10214(), loc.method_10215());
            return this.onUserInteract(player, null, new BlockInteraction(block, point));
        }
        return class_1269.field_5811;
    }

    private class_1269 onRightClickAir(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        if (!world.method_8608() && playerEntity instanceof class_3222) {
            class_3222 player = (class_3222)playerEntity;
            this.onUserInteract(player, null, null);
        }
        return class_1269.field_5811;
    }

    private class_1269 onRightClickEntity(class_1657 playerEntity, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (hand == class_1268.field_5808 && !world.method_8608() && playerEntity instanceof class_3222) {
            Vector3d point;
            class_3222 player = (class_3222)playerEntity;
            Entity target = PlatformAdapter.fromFabricEntity(entity);
            if (hitResult == null) {
                point = null;
            } else {
                class_243 loc = hitResult.method_17784();
                point = Vector3d.of(loc.method_10216(), loc.method_10214(), loc.method_10215());
            }
            return this.onUserInteract(player, new EntityInteraction(target, point), null);
        }
        return class_1269.field_5811;
    }

    private class_1269 onUserInteract(class_3222 player, @Nullable EntityInteraction entityInteraction, @Nullable BlockInteraction blockInteraction) {
        User user;
        if (this.validGameMode(player) && !this.disabledWorld((class_1297)player) && (user = (User)Registries.BENDERS.get(player.method_5667())) != null) {
            Entity entity = null;
            if (entityInteraction != null) {
                entity = entityInteraction.value();
                user.store().add(EntityInteraction.KEY, entityInteraction);
            }
            Block block = null;
            if (blockInteraction != null) {
                block = blockInteraction.value();
                user.store().add(BlockInteraction.KEY, blockInteraction);
            }
            this.game().activationController().onUserInteract(user, entity, block);
        }
        return class_1269.field_5811;
    }

    private boolean onUserSneak(class_3222 player, boolean sneaking) {
        User user;
        if (this.validGameMode(player) && !this.disabledWorld((class_1297)player) && (user = (User)Registries.BENDERS.get(player.method_5667())) != null) {
            this.game().activationController().onUserSneak(user, sneaking);
        }
        return true;
    }

    private boolean onUserSprint(class_3222 player, boolean sprinting) {
        if (sprinting && this.validGameMode(player) && !this.disabledWorld((class_1297)player)) {
            return !this.game().activationController().hasSpout(player.method_5667());
        }
        return true;
    }

    private boolean onUserGlide(class_1309 entity, boolean tickElytra) {
        class_3218 world;
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof class_3218 && !this.disabledWorld(world = (class_3218)class_19372)) {
            if (ActionLimiter.isLimited(entity.method_5667(), ActionType.MOVE)) {
                return false;
            }
            User user = (User)Registries.BENDERS.get(entity.method_5667());
            return user != null && this.game().activationController().onUserGlide(user);
        }
        return false;
    }

    private void onUserGameModeChange(class_3222 player, class_1934 gameType) {
        User user;
        if (!this.disabledWorld((class_1297)player) && gameType == class_1934.field_9219 && (user = (User)Registries.BENDERS.get(player.method_5667())) != null) {
            this.game().abilityManager(user.world().key()).destroyUserInstances(user, a -> !a.description().isActivatedBy(Activation.PASSIVE));
        }
    }

    private void onHeldSlotChange(class_3222 player, int oldSlot, int newSlot) {
        if (this.disabledWorld((class_1297)player)) {
            return;
        }
        User user = (User)Registries.BENDERS.get(player.method_5667());
        if (user != null) {
            user.board().activeSlot(oldSlot + 1, newSlot + 1);
        }
    }

    private boolean onEntityTarget(class_1309 entity, class_1297 target) {
        return this.disabledWorld((class_1297)entity) || !ActionLimiter.isLimited(entity.method_5667());
    }

    private boolean onItemMerge(class_1542 first, class_1542 second) {
        if (!this.disabledWorld((class_1297)first)) {
            return this.isNotGlove((class_1297)first) && this.isNotGlove((class_1297)second);
        }
        return true;
    }

    private boolean isNotGlove(class_1297 entity) {
        return !FabricMetadata.INSTANCE.has(entity, EarthGlove.GLOVE_KEY);
    }

    private boolean onInventoryClick(class_3222 player, class_1799 stack) {
        if (ItemUtil.getKey(stack, Metadata.ARMOR_KEY) != null) {
            if (!TempArmor.MANAGER.isTemp(player.method_5667())) {
                stack.method_7939(0);
            }
            return false;
        }
        return true;
    }

    private boolean onHopperItemPickup(class_1263 container, class_1542 itemEntity) {
        class_1792 item;
        if (!this.disabledWorld((class_1297)itemEntity) && (item = itemEntity.method_6983().method_7909()) == class_1802.field_20391 && !this.isNotGlove((class_1297)itemEntity)) {
            itemEntity.method_31472();
            return false;
        }
        return true;
    }

    private boolean onDropItem(class_1309 entity, class_1799 stack) {
        if (!this.disabledWorld((class_1297)entity)) {
            this.game().activationController().ignoreNextSwing(entity.method_5667());
            return ItemUtil.getKey(stack, Metadata.ARMOR_KEY) == null;
        }
        return true;
    }

    private boolean onAccessLock(class_1657 player, Lockable lockable) {
        if (!this.disabledWorld((class_1297)player)) {
            User user = (User)Registries.BENDERS.get(player.method_5667());
            return user != null && Locksmithing.canUnlockContainer(user, lockable);
        }
        return false;
    }

    private double onEntityDamage(class_1309 entity, class_1282 source, double damage) {
        if (this.disabledWorld((class_1297)entity)) {
            return damage;
        }
        LivingEntity livingEntity = PlatformAdapter.fromFabricEntity(entity);
        Vector3d origin = null;
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity != null) {
            if (sourceEntity instanceof class_1667 && FabricMetadata.INSTANCE.has(sourceEntity, MetalCable.CABLE_KEY)) {
                return 0.0;
            }
            if (ActionLimiter.isLimited(sourceEntity.method_5667(), ActionType.DAMAGE)) {
                return 0.0;
            }
            origin = PlatformAdapter.fromFabricEntity(sourceEntity).center();
        }
        DamageCause cause = PlatformAdapter.fromFabricCause(entity.method_48923(), source);
        return this.game().activationController().onEntityDamage(livingEntity, cause, damage, origin);
    }

    private boolean onEntityAllowDamage(class_1309 entity, class_1282 source, float damage) {
        User user;
        if (damage <= 0.0f) {
            return false;
        }
        if (!this.disabledWorld((class_1297)entity) && (user = (User)Registries.BENDERS.get(entity.method_5667())) != null) {
            this.game().activationController().onUserDamage(user);
        }
        return true;
    }

    private void onUserDeath(class_1309 entity, class_1282 damageSource) {
        UUID uuid = entity.method_5667();
        ActionLimiter.MANAGER.get(uuid).ifPresent(ActionLimiter::revert);
        TempArmor.MANAGER.get(uuid).ifPresent(TempArmor::revert);
        if (this.disabledWorld((class_1297)entity) || entity instanceof class_3222) {
            return;
        }
        User user = (User)Registries.BENDERS.get(uuid);
        if (user != null) {
            this.game().activationController().onUserDeconstruct(user);
        }
    }

    private void onEntityUnload(class_1297 entity, class_3218 level) {
        if (this.disabledWorld(entity) || entity instanceof class_3222) {
            return;
        }
        Registries.BENDERS.getIfExists(entity.method_5667()).ifPresent(this.game().activationController()::onUserDeconstruct);
    }
}

