/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.listener;

import java.util.UUID;
import java.util.function.Supplier;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.fabric.listener.FabricListener;
import me.moros.bending.fabric.platform.FabricMetadata;
import me.moros.bending.fabric.platform.PlatformAdapter;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public record WorldListener(Supplier<Game> gameSupplier) implements FabricListener,
Initializer
{
    @Override
    public void init() {
        class_2960 early = class_2960.method_60655((String)"bending", (String)"early");
        ServerWorldEvents.UNLOAD.register(this::onWorldUnload);
        ServerEntityWorldChangeEvents.AFTER_ENTITY_CHANGE_WORLD.register(early, this::onChangeWorld);
        ServerEntityWorldChangeEvents.AFTER_ENTITY_CHANGE_WORLD.addPhaseOrdering(early, Event.DEFAULT_PHASE);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(early, this::onChangeWorld);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.addPhaseOrdering(early, Event.DEFAULT_PHASE);
    }

    private void onWorldUnload(MinecraftServer server, class_3218 world) {
        class_2960 key = world.method_27983().method_29177();
        this.game().worldManager().onWorldUnload((Key)key);
        FabricMetadata.INSTANCE.cleanup((Key)key);
    }

    private void onChangeWorld(class_1297 originalEntity, class_1297 newEntity, class_3218 origin, class_3218 destination) {
        UUID uuid = newEntity.method_5667();
        User user = (User)Registries.BENDERS.get(uuid);
        if (user != null) {
            PlatformAdapter.toFabricEntityWrapper(user).setHandle(newEntity);
            this.onChangeWorld(uuid, origin, destination);
        }
    }

    private void onChangeWorld(class_3222 player, class_3218 origin, class_3218 destination) {
        this.onChangeWorld(player.method_5667(), origin, destination);
    }

    private void onChangeWorld(UUID uuid, class_3218 origin, class_3218 destination) {
        class_2960 from = origin.method_27983().method_29177();
        class_2960 to = destination.method_27983().method_29177();
        this.game().worldManager().onUserChangeWorld(uuid, (Key)from, (Key)to);
    }
}

