/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.moros.bending.api.util.data.DataContainer;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.api.util.data.DataKey;
import me.moros.math.Position;
import me.moros.math.Vector3i;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1297;

public enum FabricMetadata {
    INSTANCE;

    private final Map<Key, Pair<Position, UUID>> worlds = new ConcurrentHashMap<Key, Pair<Position, UUID>>();

    private Pair<Position, UUID> worldData(Key key) {
        return this.worlds.computeIfAbsent(key, u -> new Pair(new ConcurrentHashMap(), new ConcurrentHashMap()));
    }

    private DataHolder blockData(Map<Position, DataContainer> dataMap, int x, int y, int z) {
        return dataMap.computeIfAbsent(Vector3i.of(x, y, z), p -> DataContainer.simple());
    }

    private DataHolder entityData(Map<UUID, DataContainer> dataMap, UUID uuid) {
        return dataMap.computeIfAbsent(uuid, id -> DataContainer.simple());
    }

    public DataHolder metadata(Key world, int x, int y, int z) {
        return this.blockData(this.worldData(world).map1(), x, y, z);
    }

    public DataHolder metadata(Key world, UUID uuid) {
        return this.entityData(this.worldData(world).map2(), uuid);
    }

    public DataHolder metadata(class_1297 entity) {
        return this.metadata((Key)entity.method_73183().method_27983().method_29177(), entity.method_5667());
    }

    public boolean has(Key world, int x, int y, int z, DataKey<?> key) {
        return this.has(world, key, p -> p.map1().get(Vector3i.of(x, y, z)));
    }

    public boolean has(class_1297 entity, DataKey<?> key) {
        return this.has((Key)entity.method_73183().method_27983().method_29177(), key, p -> p.map2().get(entity.method_5667()));
    }

    private boolean has(Key worldKey, DataKey<?> key, Function<Pair<Position, UUID>, DataHolder> mapper) {
        Pair<Position, UUID> pair = this.worlds.get(worldKey);
        if (pair == null) {
            return false;
        }
        DataHolder dataHolder = mapper.apply(pair);
        return dataHolder != null && dataHolder.has(key);
    }

    public void removeEmpty() {
        this.worlds.entrySet().removeIf(e -> ((Pair)e.getValue()).cleanup());
    }

    public void cleanup() {
        this.worlds.clear();
    }

    public void cleanup(Key world) {
        this.worlds.remove(world);
    }

    private record Pair<V1, V2>(Map<V1, DataContainer> map1, Map<V2, DataContainer> map2) {
        private boolean cleanup() {
            this.map1().entrySet().removeIf(e -> ((DataContainer)e.getValue()).isEmpty());
            this.map2().entrySet().removeIf(e -> ((DataContainer)e.getValue()).isEmpty());
            return this.map1.isEmpty() && this.map2.isEmpty();
        }
    }
}

