/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform;

import bending.libraries.caffeine.cache.Caffeine;
import bending.libraries.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import me.moros.bending.api.ability.element.ElementHandler;
import me.moros.bending.api.adapter.NativeAdapter;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.gui.ElementGui;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.PlatformFactory;
import me.moros.bending.api.platform.PlatformType;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemBuilder;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.user.User;
import me.moros.bending.fabric.adapter.NativeAdapterImpl;
import me.moros.bending.fabric.gui.BoardImpl;
import me.moros.bending.fabric.gui.ElementMenu;
import me.moros.bending.fabric.platform.FabricRegistryInitializer;
import me.moros.bending.fabric.platform.PlatformAdapter;
import me.moros.bending.fabric.platform.item.FabricItemBuilder;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.fabricmc.fabric.api.tag.convention.v2.TagUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;

public class FabricPlatform
implements Platform,
PlatformFactory {
    private final MinecraftServer server;
    private final NativeAdapter adapter;
    private final LoadingCache<Item, ItemSnapshot> campfireRecipesCache;

    public FabricPlatform(MinecraftServer server) {
        this.server = server;
        new FabricRegistryInitializer().init();
        this.adapter = new NativeAdapterImpl(server);
        this.campfireRecipesCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(this::findCampfireRecipe);
    }

    @Override
    public PlatformFactory factory() {
        return this;
    }

    @Override
    public PlatformType type() {
        return PlatformType.FABRIC;
    }

    @Override
    public boolean hasNativeSupport() {
        return true;
    }

    @Override
    public NativeAdapter nativeAdapter() {
        return this.adapter;
    }

    @Override
    public Optional<Board> buildBoard(User user) {
        if (user instanceof Player) {
            return Optional.of(new BoardImpl(this.server, user));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ElementGui> buildMenu(ElementHandler handler, User user) {
        if (user instanceof Player) {
            Player player = (Player)((Object)user);
            return Optional.of(ElementMenu.createMenu(handler, player));
        }
        return Optional.empty();
    }

    @Override
    public ItemBuilder itemBuilder(Item item) {
        return new FabricItemBuilder(PlatformAdapter.toFabricItem(item), this.server);
    }

    @Override
    public ItemBuilder itemBuilder(ItemSnapshot snapshot) {
        return new FabricItemBuilder(PlatformAdapter.toFabricItem(snapshot), this.server);
    }

    @Override
    public Optional<ItemSnapshot> campfireRecipeCooked(Item input) {
        ItemSnapshot result = this.campfireRecipesCache.get(input);
        return result.type() == Item.AIR ? Optional.empty() : Optional.of(result);
    }

    @Override
    public Collection<ItemSnapshot> calculateOptimalOreDrops(Block block) {
        class_3218 level = PlatformAdapter.toFabricWorld(block.world());
        class_2338 pos = new class_2338(block.blockX(), block.blockY(), block.blockZ());
        class_2680 state = level.method_8320(pos);
        if (TagUtil.isIn((class_5455)this.server.method_30611(), (class_6862)ConventionalBlockTags.ORES, (Object)state.method_26204())) {
            class_1799 item = new class_1799((class_1935)class_1802.field_8377);
            class_6880.class_6883 fortune = this.server.method_30611().method_30530(class_7924.field_41265).method_46747(class_1893.field_9130);
            item.method_7978((class_6880)fortune, 2);
            return class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)level.method_8321(pos), null, (class_1799)item).stream().map(PlatformAdapter::fromFabricItem).toList();
        }
        return List.of();
    }

    private ItemSnapshot findCampfireRecipe(Item item) {
        class_1799 fabricItem = PlatformAdapter.toFabricItem(item);
        class_9696 recipeInput = new class_9696(fabricItem);
        return this.server.method_3772().getAllMatches(class_3956.field_17549, (class_9695)recipeInput, (class_1937)this.server.method_30002()).map(class_8786::comp_1933).findAny().map(r -> PlatformAdapter.fromFabricItem(r.method_59998(recipeInput, (class_7225.class_7874)this.server.method_30611()))).orElseGet(ItemSnapshot.AIR);
    }
}

