/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockTag;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemTag;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.potion.PotionEffectTag;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.platform.sound.SoundGroup;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.registry.Tag;
import me.moros.bending.api.registry.TagBuilder;
import me.moros.bending.common.util.RegistryInitializer;
import me.moros.bending.fabric.mixin.accessor.BlockBehaviourAccess;
import me.moros.bending.fabric.platform.PlatformAdapter;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minecraft.class_1291;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2346;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

final class FabricRegistryInitializer
implements RegistryInitializer {
    FabricRegistryInitializer() {
    }

    @Override
    public void initBlockTypeRegistry(Registry<Key, BlockType> registry, Registry<Key, BlockProperties> propertyRegistry, Registry<Key, BlockState> stateRegistry, Registry<Key, Item> itemRegistry) {
        for (class_2248 mat : class_7923.field_41175) {
            class_2960 key = class_7923.field_41175.method_10221((Object)mat);
            BlockType type = registry.getOrThrow((Key)key);
            class_2680 data = mat.method_9564();
            stateRegistry.register(PlatformAdapter.fromFabricData(data));
            propertyRegistry.register(this.mapProperties(type, data));
            class_1792 class_17922 = mat.method_8389();
            if (!(class_17922 instanceof class_1747)) continue;
            class_1747 item = (class_1747)class_17922;
            itemRegistry.register(PlatformAdapter.fromFabricItem((class_1792)item));
        }
    }

    @Override
    public void initBlockTypeTagRegistry(Registry<Key, BlockType> registry, Function<Key, TagBuilder<BlockType, BlockTag>> builder) {
        this.initTag((Registry)registry, BlockTag::builder, (class_2378)class_7923.field_41175);
    }

    @Override
    public void initEntityTypeRegistry(Registry<Key, EntityType> registry) {
        this.init(registry, (class_2378<?>)class_7923.field_41177);
    }

    @Override
    public void initItemRegistry(Registry<Key, Item> registry) {
        this.init(registry, (class_2378<?>)class_7923.field_41178);
    }

    @Override
    public void initItemTagRegistry(Registry<Key, Item> registry, Function<Key, TagBuilder<Item, ItemTag>> builder) {
        this.initTag((Registry)registry, builder, (class_2378)class_7923.field_41178);
    }

    @Override
    public void initParticleRegistry(Registry<Key, Particle> registry) {
        this.init(registry, class_7923.field_41180);
    }

    @Override
    public void initPotionEffectRegistry(Registry<Key, PotionEffect> registry) {
        this.init(registry, class_7923.field_41174);
    }

    @Override
    public void initPotionEffectTagRegistry(Registry<Key, PotionEffect> registry, Function<Key, TagBuilder<PotionEffect, PotionEffectTag>> builder) {
        class_2378 vanillaRegistry = class_7923.field_41174;
        Map<PotionEffectTag, List<class_1291>> map = vanillaRegistry.method_10220().collect(Collectors.groupingBy(PlatformAdapter::potionCategory));
        for (Map.Entry<PotionEffectTag, List<class_1291>> entry : map.entrySet()) {
            List<PotionEffect> data = entry.getValue().stream().map(p -> (PotionEffect)registry.get((Key)vanillaRegistry.method_10221(p))).toList();
            registry.getTagOrCreate(entry.getKey().key(), k -> ((TagBuilder)builder.apply((Key)k)).add(data).build());
        }
    }

    @Override
    public void initSoundRegistry(Registry<Key, Sound> registry) {
        this.init(registry, class_7923.field_41172);
    }

    private void init(Registry<Key, ?> registry, class_2378<?> vanillaRegistry) {
        for (class_2960 key : vanillaRegistry.method_10235()) {
            registry.get((Key)key);
        }
    }

    private <V extends Keyed, T extends Tag<V>, S> void initTag(Registry<Key, V> registry, Function<Key, TagBuilder<V, T>> builder, class_2378<S> defaultedRegistry) {
        List tags = defaultedRegistry.method_40272().toList();
        for (class_6885.class_6888 entry : tags) {
            List<Keyed> data = entry.method_40239().map(class_6880::comp_349).map(arg_0 -> defaultedRegistry.method_10221(arg_0)).map(registry::get).filter(Objects::nonNull).toList();
            if (data.isEmpty()) continue;
            class_2960 tagKey = entry.method_40251().comp_327();
            registry.getTagOrCreate((Key)tagKey, k -> ((TagBuilder)builder.apply((Key)k)).add(data).build());
        }
    }

    private BlockProperties mapProperties(BlockType type, class_2680 data) {
        class_2248 block = data.method_26204();
        return BlockProperties.builder(type, block.method_63499()).isAir(data.method_26215()).isSolid(data.method_51367()).isLiquid(data.method_51176()).isFlammable(((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(block)).getBurnChance() > 0).hasGravity(data.method_26204() instanceof class_2346).isCollidable(((BlockBehaviourAccess)block).bending$hasCollision()).hardness(block.method_36555()).soundGroup(this.mapSoundGroup(data.method_26231())).build();
    }

    private SoundGroup mapSoundGroup(class_2498 type) {
        return new SoundGroup(this.mapSound(type.method_10595()), this.mapSound(type.method_10594()), this.mapSound(type.method_10598()), this.mapSound(type.method_10596()), this.mapSound(type.method_10593()));
    }

    private Sound mapSound(class_3414 sound) {
        return Sound.registry().getOrThrow((Key)sound.comp_3319());
    }
}

