/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform;

import java.util.Map;
import java.util.Optional;
import me.moros.bending.api.util.data.DataKey;
import net.minecraft.class_2487;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NBTUtil {
    private static final Map<Class<?>, Adapter<?>> ADAPTERS = Map.ofEntries(NBTUtil.entry(String.class, class_2487::method_10558, class_2487::method_10582), NBTUtil.entry(Boolean.class, class_2487::method_10577, class_2487::method_10556), NBTUtil.entry(Short.class, class_2487::method_10568, class_2487::method_10575), NBTUtil.entry(Float.class, class_2487::method_10583, class_2487::method_10548), NBTUtil.entry(Double.class, class_2487::method_10574, class_2487::method_10549), NBTUtil.entry(Byte.class, class_2487::method_10571, class_2487::method_10567), NBTUtil.entry(byte[].class, class_2487::method_10547, class_2487::method_10570), NBTUtil.entry(Integer.class, class_2487::method_10550, class_2487::method_10569), NBTUtil.entry(int[].class, class_2487::method_10561, class_2487::method_10539), NBTUtil.entry(Long.class, class_2487::method_10537, class_2487::method_10544), NBTUtil.entry(long[].class, class_2487::method_10565, class_2487::method_10564));

    private NBTUtil() {
    }

    private static <T> Map.Entry<Class<T>, Adapter<T>> entry(Class<T> classType, Reader<T> reader, Writer<T> writer) {
        return Map.entry(classType, new Adapter<T>(reader, writer));
    }

    public static <T> @Nullable T read(class_2487 tag, DataKey<T> key) {
        if (!tag.method_10545(key.asString())) {
            return null;
        }
        Adapter<T> adapter = NBTUtil.getAdapter(key.type());
        return adapter == null ? null : adapter.reader().read(tag, key.asString()).orElse(null);
    }

    public static <T> void write(class_2487 tag, DataKey<T> key, T value) {
        Adapter<T> adapter = NBTUtil.getAdapter(key.type());
        if (adapter != null) {
            adapter.writer().write(tag, key.asString(), value);
        }
    }

    private static <T> @Nullable Adapter<T> getAdapter(Class<T> type) {
        return ADAPTERS.get(type);
    }

    private record Adapter<T>(Reader<T> reader, Writer<T> writer) {
    }

    @FunctionalInterface
    private static interface Reader<T> {
        public Optional<T> read(class_2487 var1, String var2);
    }

    @FunctionalInterface
    private static interface Writer<T> {
        public void write(class_2487 var1, String var2, T var3);
    }
}

