/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform;

import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.damage.DamageCause;
import me.moros.bending.api.platform.entity.DelegateEntity;
import me.moros.bending.api.platform.entity.DelegateLivingEntity;
import me.moros.bending.api.platform.entity.DelegatePlayer;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.GameMode;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.potion.Potion;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.potion.PotionEffectTag;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.user.User;
import me.moros.bending.fabric.platform.block.FabricBlockState;
import me.moros.bending.fabric.platform.entity.FabricEntity;
import me.moros.bending.fabric.platform.entity.FabricLivingEntity;
import me.moros.bending.fabric.platform.entity.FabricPlayer;
import me.moros.bending.fabric.platform.item.FabricItem;
import me.moros.bending.fabric.platform.world.FabricWorld;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_8109;

public final class PlatformAdapter {
    private PlatformAdapter() {
    }

    public static class_6880<class_1291> toFabricPotion(PotionEffect effect) {
        return (class_6880)class_7923.field_41174.method_10223(PlatformAdapter.rsl(effect.key())).orElseThrow();
    }

    public static class_1293 toFabricPotion(Potion p) {
        return new class_1293(PlatformAdapter.toFabricPotion(p.effect()), p.duration(), p.amplifier(), p.ambient(), p.particles(), p.icon());
    }

    public static Potion fromFabricPotion(class_1293 p) {
        PotionEffect effect = PotionEffect.registry().getOrThrow((Key)class_7923.field_41174.method_10221((Object)((class_1291)p.method_5579().comp_349())));
        return Potion.builder(effect).duration(p.method_5584()).amplifier(p.method_5578()).ambient(p.method_5591()).particles(p.method_5581()).icon(p.method_5592()).build();
    }

    public static PotionEffectTag potionCategory(class_1291 type) {
        return switch (type.method_18792()) {
            default -> throw new MatchException(null, null);
            case class_4081.field_18271 -> PotionEffectTag.BENEFICIAL;
            case class_4081.field_18273 -> PotionEffectTag.NEUTRAL;
            case class_4081.field_18272 -> PotionEffectTag.HARMFUL;
        };
    }

    public static Item fromFabricItem(class_1792 material) {
        return Item.registry().getOrThrow((Key)class_7923.field_41178.method_10221((Object)material));
    }

    public static BlockType fromFabricBlock(class_2248 material) {
        return BlockType.registry().getOrThrow((Key)class_7923.field_41175.method_10221((Object)material));
    }

    public static class_1792 toFabricItemType(Item item) {
        return (class_1792)class_7923.field_41178.method_63535(PlatformAdapter.rsl(item.key()));
    }

    public static class_1799 toFabricItem(Item item) {
        return new class_1799((class_1935)PlatformAdapter.toFabricItemType(item));
    }

    public static class_1799 toFabricItem(ItemSnapshot item) {
        return ((FabricItem)item).copy();
    }

    public static ItemSnapshot fromFabricItem(class_1799 itemStack) {
        return new FabricItem(itemStack);
    }

    public static class_2960 rsl(Key key) {
        return (class_2960)key.key();
    }

    public static World fromFabricWorld(class_3218 world) {
        return new FabricWorld(world);
    }

    public static class_3218 toFabricWorld(World world) {
        return ((FabricWorld)world).handle();
    }

    public static Entity fromFabricEntity(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return PlatformAdapter.fromFabricEntity(player);
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return PlatformAdapter.fromFabricEntity(living);
        }
        return new FabricEntity(entity);
    }

    public static LivingEntity fromFabricEntity(class_1309 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return PlatformAdapter.fromFabricEntity(player);
        }
        return new FabricLivingEntity(entity);
    }

    public static Player fromFabricEntity(class_3222 entity) {
        return new FabricPlayer(entity);
    }

    public static FabricLivingEntity toFabricEntityWrapper(User user) {
        return (FabricLivingEntity)((DelegateLivingEntity)((Object)user)).entity();
    }

    public static class_1297 toFabricEntity(Entity entity) {
        if (entity instanceof DelegateEntity) {
            DelegateEntity delegate = (DelegateEntity)entity;
            return PlatformAdapter.toFabricEntity(delegate.entity());
        }
        return ((FabricEntity)entity).handle();
    }

    public static class_1309 toFabricEntity(LivingEntity entity) {
        if (entity instanceof DelegateLivingEntity) {
            DelegateLivingEntity delegate = (DelegateLivingEntity)entity;
            return PlatformAdapter.toFabricEntity(delegate.entity());
        }
        return ((FabricLivingEntity)entity).handle();
    }

    public static class_3222 toFabricEntity(Player player) {
        if (player instanceof DelegatePlayer) {
            DelegatePlayer delegate = (DelegatePlayer)player;
            return PlatformAdapter.toFabricEntity(delegate.entity());
        }
        return ((FabricPlayer)player).handle();
    }

    public static DamageCause fromFabricCause(class_8109 sources, class_1282 source) {
        if (source.method_48789(class_8103.field_42249)) {
            return DamageCause.EXPLOSION;
        }
        if (source.method_48789(class_8103.field_42246)) {
            return DamageCause.FIRE;
        }
        if (source.method_48789(class_8103.field_42250)) {
            return DamageCause.FALL;
        }
        if (source.equals(sources.method_48828())) {
            return DamageCause.KINETIC;
        }
        if (source.equals(sources.method_48822())) {
            return DamageCause.SUFFOCATION;
        }
        return DamageCause.CUSTOM;
    }

    public static BlockState fromFabricData(class_2680 data) {
        return new FabricBlockState(data);
    }

    public static class_2680 toFabricData(BlockState state) {
        return ((FabricBlockState)state).handle();
    }

    public static GameMode fromFabricGameMode(class_1934 gameType) {
        return switch (gameType) {
            default -> throw new MatchException(null, null);
            case class_1934.field_9215 -> GameMode.SURVIVAL;
            case class_1934.field_9220 -> GameMode.CREATIVE;
            case class_1934.field_9216 -> GameMode.ADVENTURE;
            case class_1934.field_9219 -> GameMode.SPECTATOR;
        };
    }
}

