/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform.particle;

import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleContext;
import me.moros.bending.api.platform.particle.ParticleDustData;
import me.moros.bending.fabric.platform.PlatformAdapter;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_5743;
import net.minecraft.class_7227;
import net.minecraft.class_7290;
import net.minecraft.class_7923;
import net.minecraft.class_9848;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ParticleMapper {
    public static @Nullable class_2394 mapParticleOptions(ParticleContext<?> context) {
        Particle p = context.particle();
        class_2396 fabricParticle = (class_2396)class_7923.field_41180.method_63535(PlatformAdapter.rsl(p.key()));
        if (fabricParticle != null) {
            Object data = context.data();
            if ((p == Particle.BLOCK || p == Particle.FALLING_DUST || p == Particle.BLOCK_MARKER) && data instanceof BlockState) {
                BlockState state = (BlockState)data;
                return new class_2388(fabricParticle, PlatformAdapter.toFabricData(state));
            }
            if (p == Particle.ITEM && data instanceof Item) {
                Item item = (Item)data;
                return new class_2392(fabricParticle, PlatformAdapter.toFabricItem(item));
            }
            if (p == Particle.DUST && data instanceof ParticleDustData) {
                ParticleDustData dust = (ParticleDustData)data;
                return new class_2390(ParticleMapper.fromColor(dust.red(), dust.green(), dust.blue()), dust.size());
            }
            if (p == Particle.DUST_COLOR_TRANSITION && data instanceof ParticleDustData.Transitive) {
                ParticleDustData.Transitive dust = (ParticleDustData.Transitive)data;
                int from = ParticleMapper.fromColor(dust.red(), dust.green(), dust.blue());
                int to = ParticleMapper.fromColor(dust.toRed(), dust.toGreen(), dust.toBlue());
                return new class_5743(from, to, dust.size());
            }
            if (p == Particle.SCULK_CHARGE && data instanceof Float) {
                Float number = (Float)data;
                return new class_7227(number.floatValue());
            }
            if (p == Particle.SHRIEK && data instanceof Integer) {
                Integer number = (Integer)data;
                return new class_7290(number.intValue());
            }
            return (class_2400)fabricParticle;
        }
        return null;
    }

    private static int fromColor(int red, int green, int blue) {
        return class_9848.method_61323((int)red, (int)green, (int)blue);
    }
}

