/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.raytrace.BlockRayTrace;
import me.moros.bending.api.collision.raytrace.CompositeRayTrace;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.collision.raytrace.RayTrace;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.block.Lockable;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.particle.ParticleContext;
import me.moros.bending.api.platform.world.World;
import me.moros.bending.api.util.data.DataHolder;
import me.moros.bending.fabric.mixin.accessor.ChunkMapAccess;
import me.moros.bending.fabric.mixin.accessor.FallingBlockEntityAccess;
import me.moros.bending.fabric.platform.FabricMetadata;
import me.moros.bending.fabric.platform.PlatformAdapter;
import me.moros.bending.fabric.platform.particle.ParticleMapper;
import me.moros.bending.fabric.platform.world.RayTraceUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5268;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7923;
import org.checkerframework.checker.nullness.qual.Nullable;

public record FabricWorld(class_3218 handle) implements World
{
    private class_2680 at(int x, int y, int z) {
        return this.handle().method_8320(new class_2338(x, y, z));
    }

    @Override
    public BlockType getBlockType(int x, int y, int z) {
        return this.getBlockState(x, y, z).type();
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return PlatformAdapter.fromFabricData(this.at(x, y, z));
    }

    @Override
    public AABB blockBounds(int x, int y, int z) {
        class_238 box;
        class_265 shape;
        class_2680 b = this.at(x, y, z);
        if (PlatformAdapter.fromFabricData(b).type().isCollidable() && !(shape = b.method_26218((class_1922)this.handle(), new class_2338(x, y, z))).method_1110() && (box = shape.method_1107()).method_995() > 0.0) {
            Vector3d min = Vector3d.of((double)x + box.field_1323, (double)y + box.field_1322, (double)z + box.field_1321);
            Vector3d max = Vector3d.of((double)x + box.field_1320, (double)y + box.field_1325, (double)z + box.field_1324);
            return AABB.of(min, max);
        }
        return AABB.dummy();
    }

    @Override
    public DataHolder blockMetadata(int x, int y, int z) {
        return FabricMetadata.INSTANCE.metadata(this.key(), x, y, z);
    }

    private @Nullable class_2586 blockEntity(int x, int y, int z) {
        return this.handle().method_8321(new class_2338(x, y, z));
    }

    @Override
    public boolean isBlockEntity(Position position) {
        return this.blockEntity(position.blockX(), position.blockY(), position.blockZ()) != null;
    }

    @Override
    public @Nullable Lockable containerLock(Position position) {
        Lockable lockable;
        class_2586 tile = this.blockEntity(position.blockX(), position.blockY(), position.blockZ());
        return tile instanceof Lockable ? (lockable = (Lockable)tile) : null;
    }

    @Override
    public boolean setBlockState(int x, int y, int z, BlockState state) {
        return this.handle().method_8652(new class_2338(x, y, z), PlatformAdapter.toFabricData(state), 2);
    }

    @Override
    public List<Entity> nearbyEntities(AABB box, Predicate<Entity> predicate, int limit) {
        class_243 min = new class_243(box.min().x(), box.min().y(), box.min().z());
        class_243 max = new class_243(box.max().x(), box.max().y(), box.max().z());
        class_238 aabb = new class_238(min, max);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (class_1297 vanillaEntity : this.handle().method_8335(null, aabb)) {
            Entity entity = PlatformAdapter.fromFabricEntity(vanillaEntity);
            if (!predicate.test(entity)) continue;
            entities.add(entity);
            if (limit <= 0 || entities.size() < limit) continue;
            return entities;
        }
        return entities;
    }

    @Override
    public String name() {
        return ((class_5268)this.handle().method_8401()).method_150();
    }

    @Override
    public int minHeight() {
        return this.handle().method_31607();
    }

    @Override
    public int maxHeight() {
        return this.handle().method_31600();
    }

    @Override
    public <T> void spawnParticle(ParticleContext<T> context) {
        class_2394 options = ParticleMapper.mapParticleOptions(context);
        if (options != null) {
            this.handle().method_65096(options, context.position().x(), context.position().y(), context.position().z(), context.count(), context.offset().x(), context.offset().y(), context.offset().z(), context.extra());
        }
    }

    @Override
    public BlockRayTrace rayTraceBlocks(Context context) {
        return RayTraceUtil.rayTraceBlocks(context, this.handle(), this);
    }

    @Override
    public CompositeRayTrace rayTraceEntities(Context context, double range) {
        Entity result = null;
        Vector3d resPos = null;
        double minDistSq = Double.MAX_VALUE;
        Vector3d dir = (Vector3d)context.dir().normalize().multiply(range);
        Vector3d endPoint = (Vector3d)context.origin().add(dir);
        AABB box = AABB.fromRay(context.origin(), dir, context.raySize());
        class_238 aabb = new class_238(box.min().x(), box.min().y(), box.min().z(), box.max().x(), box.max().y(), box.max().z());
        class_243 vec3d1 = new class_243(context.origin().x(), context.origin().y(), context.origin().z());
        class_243 vec3d2 = new class_243(endPoint.x(), endPoint.y(), endPoint.z());
        for (class_1297 fabricEntity : this.handle().method_8335(null, aabb)) {
            class_243 pos = fabricEntity.method_5829().method_992(vec3d1, vec3d2).orElse(null);
            if (pos == null) continue;
            Entity entity = PlatformAdapter.fromFabricEntity(fabricEntity);
            double distSq = pos.method_1025(vec3d1);
            if (!(distSq < minDistSq)) continue;
            result = entity;
            resPos = Vector3d.of(pos.method_10216(), pos.method_10214(), pos.method_10215());
            minDistSq = distSq;
        }
        return result == null ? RayTrace.miss(endPoint) : RayTrace.hit(resPos, result);
    }

    @Override
    public boolean isDay() {
        return this.dimension() == World.Dimension.OVERWORLD && this.handle().method_8530();
    }

    @Override
    public boolean isNight() {
        return this.dimension() == World.Dimension.OVERWORLD && this.handle().method_23886();
    }

    @Override
    public Entity createEntity(Position pos, EntityType type) {
        if (type == EntityType.PLAYER) {
            throw new IllegalArgumentException("Cannot create a Player.");
        }
        double x = pos.x();
        double y = pos.y();
        double z = pos.z();
        class_1540 entity = null;
        if (type == EntityType.FALLING_BLOCK) {
            entity = FallingBlockEntityAccess.bending$create((class_1937)this.handle(), x, y, z, class_2246.field_10102.method_9564());
        } else if (type == EntityType.ITEM) {
            entity = new class_1542((class_1937)this.handle(), x, y, z, class_1802.field_20391.method_7854());
        }
        if (entity == null) {
            class_1299 entityType = (class_1299)class_7923.field_41177.method_63535(PlatformAdapter.rsl(type.key()));
            entity = Objects.requireNonNull(entityType.method_5883((class_1937)this.handle(), class_3730.field_16461));
            entity.method_24203(x, y, z);
        }
        return PlatformAdapter.fromFabricEntity(entity);
    }

    @Override
    public boolean addEntity(Entity entity) {
        return this.handle().method_8649(PlatformAdapter.toFabricEntity(entity));
    }

    @Override
    public boolean breakNaturally(int x, int y, int z) {
        return this.handle().method_22352(new class_2338(x, y, z), true);
    }

    @Override
    public Entity dropItem(Position position, ItemSnapshot item, boolean canPickup) {
        class_1799 type = PlatformAdapter.toFabricItem(item);
        class_1542 droppedItem = new class_1542((class_1937)this.handle(), position.x(), position.y(), position.z(), type);
        if (!canPickup) {
            droppedItem.method_6989();
        }
        this.handle().method_8649((class_1297)droppedItem);
        return PlatformAdapter.fromFabricEntity((class_1297)droppedItem);
    }

    @Override
    public Entity createFallingBlock(Position center, BlockState state, boolean gravity) {
        class_2680 data = PlatformAdapter.toFabricData(state);
        class_1540 fabricEntity = FallingBlockEntityAccess.bending$create((class_1937)this.handle(), center.x(), center.y(), center.z(), data);
        fabricEntity.field_7192 = 1;
        fabricEntity.method_5875(!gravity);
        fabricEntity.field_7193 = false;
        ((FallingBlockEntityAccess)fabricEntity).bending$cancelDrop(true);
        this.handle().method_8649((class_1297)fabricEntity);
        return PlatformAdapter.fromFabricEntity((class_1297)fabricEntity);
    }

    @Override
    public int lightLevel(int x, int y, int z) {
        return this.handle().method_22339(new class_2338(x, y, z));
    }

    @Override
    public int blockLightLevel(int x, int y, int z) {
        return this.handle().method_8314(class_1944.field_9282, new class_2338(x, y, z));
    }

    @Override
    public int skyLightLevel(int x, int y, int z) {
        return this.handle().method_8314(class_1944.field_9284, new class_2338(x, y, z));
    }

    @Override
    public World.Dimension dimension() {
        class_6880 r = this.handle().method_40134();
        if (r.method_40225(class_7134.field_37666) || r.method_40225(class_7134.field_37669)) {
            return World.Dimension.OVERWORLD;
        }
        if (r.method_40225(class_7134.field_37667)) {
            return World.Dimension.NETHER;
        }
        if (r.method_40225(class_7134.field_37668)) {
            return World.Dimension.END;
        }
        return World.Dimension.CUSTOM;
    }

    @Override
    public CompletableFuture<?> loadChunkAsync(int x, int z) {
        return this.handle().method_14178().method_17299(x, z, class_2806.field_12798, false);
    }

    @Override
    public int viewDistance() {
        return ((ChunkMapAccess)this.handle().method_14178().field_17254).bending$viewDistance();
    }

    public Iterable<? extends Audience> audiences() {
        return this.handle().method_18456();
    }

    public Key key() {
        return this.handle().method_27983().method_29177();
    }
}

