/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.fabric.platform.world;

import java.util.function.Function;
import me.moros.bending.api.collision.raytrace.BlockRayTrace;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.collision.raytrace.RayTrace;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.world.World;
import me.moros.math.Vector3d;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RayTraceUtil {
    private RayTraceUtil() {
    }

    static BlockRayTrace rayTraceBlocks(Context context, class_3218 level, World world) {
        Vector3d s = context.origin();
        Vector3d e = context.endPoint();
        class_243 startPos = new class_243(s.x(), s.y(), s.z());
        class_243 endPos = new class_243(e.x(), e.y(), e.z());
        class_3959.class_3960 ccb = context.ignorePassable() ? class_3959.class_3960.field_17558 : class_3959.class_3960.field_17559;
        class_3959.class_242 ccf = context.ignoreLiquids() ? class_3959.class_242.field_1348 : class_3959.class_242.field_1347;
        ClipContext clipContext = new ClipContext(context, startPos, endPos, ccb, ccf);
        return RayTraceUtil.traverseBlocks(level, clipContext, RayTrace.miss(e), RayTraceUtil.hitFactory(world));
    }

    private static BlockRayTrace traverseBlocks(class_3218 level, ClipContext context, BlockRayTrace miss, Function<class_3965, BlockRayTrace> hitFactory) {
        BlockRayTrace result;
        int k;
        int j;
        class_243 end;
        class_243 start = context.getFrom();
        if (start.equals((Object)(end = context.getTo()))) {
            return miss;
        }
        double d0 = class_3532.method_16436((double)-1.0E-7, (double)end.field_1352, (double)start.field_1352);
        double d1 = class_3532.method_16436((double)-1.0E-7, (double)end.field_1351, (double)start.field_1351);
        double d2 = class_3532.method_16436((double)-1.0E-7, (double)end.field_1350, (double)start.field_1350);
        double d3 = class_3532.method_16436((double)-1.0E-7, (double)start.field_1352, (double)end.field_1352);
        double d4 = class_3532.method_16436((double)-1.0E-7, (double)start.field_1351, (double)end.field_1351);
        double d5 = class_3532.method_16436((double)-1.0E-7, (double)start.field_1350, (double)end.field_1350);
        int i = class_3532.method_15357((double)d3);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(i, j = class_3532.method_15357((double)d4), k = class_3532.method_15357((double)d5));
        BlockRayTrace t0 = RayTraceUtil.checkBlockCollision(level, context, (class_2338)mutableBlockPos, miss, hitFactory);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = class_3532.method_17822((double)d6);
        int i1 = class_3532.method_17822((double)d7);
        int j1 = class_3532.method_17822((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - class_3532.method_15385((double)d3) : class_3532.method_15385((double)d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - class_3532.method_15385((double)d4) : class_3532.method_15385((double)d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - class_3532.method_15385((double)d5) : class_3532.method_15385((double)d5));
        do {
            if (d12 > 1.0 && d13 > 1.0 && d14 > 1.0) {
                return miss;
            }
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                    continue;
                }
                k += j1;
                d14 += d11;
                continue;
            }
            if (d13 < d14) {
                j += i1;
                d13 += d10;
                continue;
            }
            k += j1;
            d14 += d11;
        } while ((result = RayTraceUtil.checkBlockCollision(level, context, (class_2338)mutableBlockPos.method_10103(i, j, k), miss, hitFactory)) == null);
        return result;
    }

    private static @Nullable BlockRayTrace checkBlockCollision(class_3218 world, ClipContext context, class_2338 pos, BlockRayTrace miss, Function<class_3965, BlockRayTrace> hitFactory) {
        if (context.ignore(pos.method_10263(), pos.method_10264(), pos.method_10260())) {
            return null;
        }
        if (!world.method_8477(pos)) {
            return miss;
        }
        class_2680 iblockdata = world.method_8320(pos);
        if (iblockdata.method_26215()) {
            return null;
        }
        class_3610 fluid = iblockdata.method_26227();
        class_243 vec3d = context.getFrom();
        class_243 vec3d1 = context.getTo();
        class_265 voxelshape = context.getBlockShape(iblockdata, (class_1922)world, pos);
        class_3965 res0 = world.method_17745(vec3d, vec3d1, pos, voxelshape, iblockdata);
        class_265 voxelshape1 = context.getFluidShape(fluid, (class_1922)world, pos);
        class_3965 res1 = voxelshape1.method_1092(vec3d, vec3d1, pos);
        double d0 = res0 == null ? Double.MAX_VALUE : context.getFrom().method_1025(res0.method_17784());
        double d1 = res1 == null ? Double.MAX_VALUE : context.getFrom().method_1025(res1.method_17784());
        return d0 <= d1 ? hitFactory.apply(res0) : hitFactory.apply(res1);
    }

    private static Function<class_3965, @Nullable BlockRayTrace> hitFactory(World w) {
        return result -> {
            if (result == null) {
                return null;
            }
            class_243 l = result.method_17784();
            class_2338 p = result.method_17777();
            Block b = new Block(w, p.method_10263(), p.method_10264(), p.method_10260());
            return RayTrace.hit(Vector3d.of(l.method_10216(), l.method_10214(), l.method_10215()), b);
        };
    }

    private record ClipContext(Context context, class_243 getFrom, class_243 getTo, class_3959.class_3960 block, class_3959.class_242 fluid) {
        public class_265 getBlockShape(class_2680 state, class_1922 world, class_2338 pos) {
            return this.block.get(state, world, pos, class_3726.method_16194());
        }

        public class_265 getFluidShape(class_3610 state, class_1922 world, class_2338 pos) {
            return this.fluid.method_17751(state) ? state.method_17776(world, pos) : class_259.method_1073();
        }

        public boolean ignore(int x, int y, int z) {
            return this.context.ignore(x, y, z);
        }
    }
}

