/*
 * Decompiled with CFR 0.152.
 */
package me.moros.tasker;

import java.util.function.Consumer;
import java.util.function.Function;
import me.moros.tasker.AbstractTimerWheel;
import me.moros.tasker.Expiring;
import me.moros.tasker.TaskList;

final class SimpleTimerWheel
extends AbstractTimerWheel {
    private final TaskList[] wheel;
    private int index;

    SimpleTimerWheel(int length) {
        this.wheel = new TaskList[length];
        for (int i = 0; i < length; ++i) {
            this.wheel[i] = new TaskList.PendingTaskList();
        }
    }

    @Override
    protected void advanceSync() {
        this.incrementTick();
        this.expire(this.wheel[this.index]);
        this.index = (this.index + 1) % this.wheel.length;
    }

    @Override
    protected void shutdownSync(boolean run) {
        Consumer<Expiring> action = run ? Runnable::run : Function.identity()::apply;
        for (TaskList tasks : this.wheel) {
            tasks.clear(action);
        }
    }

    @Override
    protected TaskList findBucket(int ticks) {
        if (ticks > this.wheel.length) {
            throw new IllegalArgumentException("Provided ticks (" + ticks + ") greater than capacity (" + this.wheel.length + ")!");
        }
        int innerIndex = (this.index + ticks) % this.wheel.length;
        return this.wheel[innerIndex];
    }
}

