/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.cloud.suggestion;

import bending.libraries.cloud.CommandManager;
import bending.libraries.cloud.CommandTree;
import bending.libraries.cloud.context.CommandContext;
import bending.libraries.cloud.context.CommandContextFactory;
import bending.libraries.cloud.context.CommandInput;
import bending.libraries.cloud.execution.ExecutionCoordinator;
import bending.libraries.cloud.services.State;
import bending.libraries.cloud.setting.ManagerSetting;
import bending.libraries.cloud.suggestion.Suggestion;
import bending.libraries.cloud.suggestion.SuggestionFactory;
import bending.libraries.cloud.suggestion.SuggestionMapper;
import bending.libraries.cloud.suggestion.Suggestions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"bending.libraries.cloud.*"})
public final class DelegatingSuggestionFactory<C, S extends Suggestion>
implements SuggestionFactory<C, S> {
    private final List<S> singleEmptySuggestion;
    private final CommandManager<C> commandManager;
    private final CommandTree<C> commandTree;
    private final CommandContextFactory<C> contextFactory;
    private final ExecutionCoordinator<C> executionCoordinator;
    private final SuggestionMapper<S> mapper;

    public DelegatingSuggestionFactory(@NonNull CommandManager<C> commandManager, @NonNull CommandTree<C> commandTree, @NonNull CommandContextFactory<C> contextFactory, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SuggestionMapper<S> mapper) {
        this.commandManager = commandManager;
        this.commandTree = commandTree;
        this.contextFactory = contextFactory;
        this.executionCoordinator = executionCoordinator;
        this.mapper = mapper;
        this.singleEmptySuggestion = Collections.singletonList(mapper.map(Suggestion.suggestion("")));
    }

    @Override
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull CommandContext<C> context, @NonNull String input) {
        return this.suggestFromTree(context, input);
    }

    @Override
    public @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggest(@NonNull C sender, @NonNull String input) {
        return this.suggest((C)this.contextFactory.create(true, sender), input);
    }

    @Override
    public <S2 extends Suggestion> @NonNull SuggestionFactory<C, S2> mapped(@NonNull SuggestionMapper<S2> mapper) {
        return new DelegatingSuggestionFactory<C, S2>(this.commandManager, this.commandTree, this.contextFactory, this.executionCoordinator, this.mapper.then(mapper));
    }

    private @NonNull CompletableFuture<@NonNull Suggestions<C, S>> suggestFromTree(@NonNull CommandContext<C> context, @NonNull String input) {
        @NonNull CommandInput commandInput = CommandInput.of(input);
        context.store("__raw_input__", commandInput.copy());
        if (this.commandManager.preprocessContext(context, commandInput) != State.ACCEPTED) {
            if (this.commandManager.settings().get(ManagerSetting.FORCE_SUGGESTION)) {
                return CompletableFuture.completedFuture(Suggestions.create(context, this.singleEmptySuggestion, commandInput));
            }
            return CompletableFuture.completedFuture(Suggestions.create(context, Collections.emptyList(), commandInput));
        }
        return this.executionCoordinator.coordinateSuggestions(this.commandTree, context, commandInput, this.mapper).thenApply(suggestions -> {
            if (this.commandManager.settings().get(ManagerSetting.FORCE_SUGGESTION) && suggestions.list().isEmpty()) {
                return Suggestions.create(suggestions.commandContext(), this.singleEmptySuggestion, commandInput);
            }
            return suggestions;
        });
    }
}

