/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.cloud.type.range;

import bending.libraries.cloud.type.range.ByteRange;
import bending.libraries.cloud.type.range.ByteRangeImpl;
import bending.libraries.cloud.type.range.DoubleRange;
import bending.libraries.cloud.type.range.DoubleRangeImpl;
import bending.libraries.cloud.type.range.FloatRange;
import bending.libraries.cloud.type.range.FloatRangeImpl;
import bending.libraries.cloud.type.range.IntRange;
import bending.libraries.cloud.type.range.IntRangeImpl;
import bending.libraries.cloud.type.range.LongRange;
import bending.libraries.cloud.type.range.LongRangeImpl;
import bending.libraries.cloud.type.range.ShortRange;
import bending.libraries.cloud.type.range.ShortRangeImpl;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface Range<N extends Number> {
    public @NonNull N min();

    public @NonNull N max();

    public static @NonNull ByteRange byteRange(byte min, byte max) {
        return ByteRangeImpl.of(min, max);
    }

    public static @NonNull DoubleRange doubleRange(double min, double max) {
        return DoubleRangeImpl.of(min, max);
    }

    public static @NonNull FloatRange floatRange(float min, float max) {
        return FloatRangeImpl.of(min, max);
    }

    public static @NonNull IntRange intRange(int min, int max) {
        return IntRangeImpl.of(min, max);
    }

    public static @NonNull LongRange longRange(long min, long max) {
        return LongRangeImpl.of(min, max);
    }

    public static @NonNull ShortRange shortRange(short min, short max) {
        return ShortRangeImpl.of(min, max);
    }
}

