/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.eventbus;

import bending.libraries.eventbus.EventConfig;
import org.jspecify.annotations.NullMarked;

@NullMarked
record EventConfigImpl(int order, boolean acceptsCancelled, boolean exact) implements EventConfig
{
    static final EventConfigImpl DEFAULTS = new EventConfigImpl(0, true, false);

    static EventConfigImpl create(int order, boolean acceptsCancelled, boolean exact) {
        if (order == 0 && acceptsCancelled && !exact) {
            return DEFAULTS;
        }
        return new EventConfigImpl(order, acceptsCancelled, exact);
    }

    @Override
    public EventConfig order(int order) {
        return EventConfigImpl.create(order, this.acceptsCancelled, this.exact);
    }

    @Override
    public EventConfig acceptsCancelled(boolean acceptsCancelled) {
        return EventConfigImpl.create(this.order, acceptsCancelled, this.exact);
    }

    @Override
    public EventConfig exact(boolean exact) {
        return EventConfigImpl.create(this.order, this.acceptsCancelled, exact);
    }

    static final class BuilderImpl
    implements EventConfig.Builder {
        private int order = 0;
        private boolean acceptsCancelled = true;
        private boolean exact = false;

        BuilderImpl() {
        }

        @Override
        public EventConfig.Builder order(int order) {
            this.order = order;
            return this;
        }

        @Override
        public EventConfig.Builder acceptsCancelled(boolean acceptsCancelled) {
            this.acceptsCancelled = acceptsCancelled;
            return this;
        }

        @Override
        public EventConfig.Builder exact(boolean exact) {
            this.exact = exact;
            return this;
        }

        @Override
        public EventConfig build() {
            return EventConfigImpl.create(this.order, this.acceptsCancelled, this.exact);
        }
    }
}

