/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.eventbus.bus;

import bending.libraries.eventbus.Cancellable;
import bending.libraries.eventbus.EventConfig;
import bending.libraries.eventbus.EventSubscription;
import bending.libraries.eventbus.bus.EventBus;
import bending.libraries.eventbus.registry.EventRegistry;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SimpleEventBus<E>
implements EventBus<E> {
    protected final EventRegistry<E> registry;
    protected final EventBus.EventExceptionHandler exceptions;

    public SimpleEventBus(EventRegistry<E> registry, EventBus.EventExceptionHandler exceptions) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.exceptions = Objects.requireNonNull(exceptions, "exceptions");
    }

    @Override
    public void post(E event, OptionalInt order) {
        Class<?> type = event.getClass();
        List<EventSubscription<E>> subscriptions = this.registry.subscriptions(type);
        if (subscriptions.isEmpty()) {
            return;
        }
        for (EventSubscription<E> subscription : subscriptions) {
            if (!this.accepts(subscription, event, order)) continue;
            try {
                subscription.subscriber().on(event);
            }
            catch (Throwable t) {
                this.exceptions.eventExceptionCaught(this, subscription, event, t);
            }
        }
    }

    protected boolean accepts(EventSubscription<? super E> subscription, E event, OptionalInt order) {
        EventConfig config = subscription.config();
        if (config.exact() && event.getClass() != subscription.event()) {
            return false;
        }
        if (order.isPresent() && config.order() != order.getAsInt()) {
            return false;
        }
        return config.acceptsCancelled() || !this.currentlyCancelled(event);
    }

    protected boolean currentlyCancelled(E event) {
        return event instanceof Cancellable && ((Cancellable)event).cancelled();
    }
}

