/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.inventoryframework.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class UUIDTagType
implements PersistentDataType<byte[], UUID> {
    public static final UUIDTagType INSTANCE = new UUIDTagType();

    private UUIDTagType() {
    }

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<UUID> getComplexType() {
        return UUID.class;
    }

    @NotNull
    public byte[] toPrimitive(@NotNull UUID complex, @NotNull PersistentDataAdapterContext context) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(complex.getMostSignificantBits());
        buffer.putLong(complex.getLeastSignificantBits());
        return buffer.array();
    }

    @NotNull
    public UUID fromPrimitive(@NotNull byte[] primitive, @NotNull PersistentDataAdapterContext context) {
        ByteBuffer buffer = ByteBuffer.wrap(primitive);
        long most = buffer.getLong();
        long least = buffer.getLong();
        return new UUID(most, least);
    }
}

