/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.state.State;

public class MultiUpdatable<T extends Updatable>
implements Updatable,
Iterable<T> {
    protected final Collection<T> actions;

    MultiUpdatable(Collection<T> actions) {
        this.actions = new ArrayList<T>(actions);
    }

    @Override
    public Updatable.UpdateResult update() {
        this.actions.removeIf((? super E action) -> action.update() == Updatable.UpdateResult.REMOVE);
        return this.actions.isEmpty() ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    public boolean add(T action) {
        return this.actions.add(action);
    }

    public boolean removeIf(Predicate<? super T> filter) {
        return this.actions.removeIf(filter);
    }

    public Stream<T> stream() {
        return this.actions.stream();
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public int size() {
        return this.actions.size();
    }

    public void clear() {
        this.actions.clear();
    }

    public State asState() {
        return State.from(this);
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableCollection(this.actions).iterator();
    }

    public static <T extends Updatable> Builder<T> builder() {
        return new Builder();
    }

    public static <T extends Updatable> MultiUpdatable<T> empty() {
        return new Builder().build();
    }

    public static class Builder<T extends Updatable> {
        private final Collection<T> actions = new ArrayList<T>();

        private Builder() {
        }

        public Builder<T> add(T action) {
            this.actions.add(action);
            return this;
        }

        public Builder<T> addAll(Iterable<T> actions) {
            for (Updatable action : actions) {
                this.actions.add(action);
            }
            return this;
        }

        public MultiUpdatable<T> build() {
            return new MultiUpdatable<T>(this.actions);
        }
    }
}

