/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.common.basic;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.function.Predicate;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.VectorUtil;

public abstract class BlockStream
implements State {
    private StateChain chain;
    private final User user;
    private final Collection<Collider> colliders = new ArrayList<Collider>();
    private final BlockType type;
    protected Predicate<Block> diagonalsPredicate = b -> !MaterialUtil.isTransparentOrWater(b);
    protected Deque<Block> stream;
    protected Vector3d direction;
    private boolean started = false;
    private int buffer;
    private final int speed;
    protected boolean livingOnly = false;
    protected boolean controllable = true;
    protected final double range;

    protected BlockStream(User user, BlockType type, double range, int speed) {
        this.user = user;
        this.type = type;
        this.range = range;
        this.speed = Math.min(20, speed);
        this.buffer = speed;
    }

    @Override
    public void start(StateChain chain) {
        if (this.started) {
            return;
        }
        this.chain = chain;
        this.stream = new ArrayDeque<Block>();
        chain.chainStore().stream().filter(this::isValid).forEach(this.stream::addLast);
        this.started = !this.stream.isEmpty();
    }

    @Override
    public void complete() {
        if (!this.started) {
            return;
        }
        this.chain.nextState();
    }

    @Override
    public Updatable.UpdateResult update() {
        this.buffer += this.speed;
        if (this.buffer < 20) {
            return Updatable.UpdateResult.CONTINUE;
        }
        this.buffer -= 20;
        if (!this.started || this.stream.stream().noneMatch(this::isValid)) {
            return Updatable.UpdateResult.REMOVE;
        }
        Block head = this.stream.getFirst();
        Vector3d current = head.center();
        if (this.controllable || this.direction == null) {
            Vector3d targetLoc = this.user.rayTrace(this.range).cast(this.user.world()).entityEyeLevelOrPosition();
            if (head.distanceSq(targetLoc.floor()) < 1.1) {
                targetLoc = (Vector3d)targetLoc.add(this.user.direction());
            }
            this.direction = ((Vector3d)targetLoc.subtract(current)).normalize();
        }
        Vector3d originalVector = current;
        Block originBlock = this.user.world().blockAt(originalVector);
        current = (Vector3d)current.add(this.direction);
        head = this.user.world().blockAt(current);
        if (!this.user.canBuild(head)) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.clean(this.stream.removeLast());
        if (current.distanceSq(this.user.eyeLocation()) <= this.range * this.range) {
            boolean canRender = true;
            for (Vector3i v : VectorUtil.decomposeDiagonals(originalVector, this.direction)) {
                Block b = originBlock.offset(v);
                if (!this.diagonalsPredicate.test(b)) continue;
                canRender = false;
                this.onBlockHit(b);
                break;
            }
            if (canRender) {
                this.renderHead(head);
                this.stream.addFirst(head);
            }
        }
        this.postRender();
        this.colliders.clear();
        boolean hit = false;
        for (Block block : this.stream) {
            AABB collider = AABB.EXPANDED_BLOCK_BOUNDS.at(block);
            this.colliders.add(collider);
            hit |= CollisionUtil.handle(this.user, collider, this::onEntityHit, this.livingOnly, false);
        }
        return hit ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    public void postRender() {
    }

    public abstract boolean onEntityHit(Entity var1);

    public void onBlockHit(Block block) {
    }

    public Collection<Collider> colliders() {
        return this.colliders;
    }

    protected void renderHead(Block block) {
        if (this.type == BlockType.WATER && MaterialUtil.isWater(block)) {
            ParticleBuilder.bubble(block).spawn(this.user.world());
        } else {
            TempBlock.builder(this.type).build(block);
        }
    }

    public boolean isValid(Block block) {
        if (this.type == BlockType.WATER) {
            return MaterialUtil.isWater(block);
        }
        return this.type == block.type();
    }

    public void cleanAll() {
        this.stream.forEach(this::clean);
    }

    private void clean(Block block) {
        if (this.isValid(block)) {
            TempBlock.air().build(block);
        }
    }
}

