/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.element;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.collect.ElementSet;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.translation.Translatable;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum Element implements Keyed,
Translatable
{
    AIR("Air", ColorPalette.AIR),
    WATER("Water", ColorPalette.WATER),
    EARTH("Earth", ColorPalette.EARTH),
    FIRE("Fire", ColorPalette.FIRE);

    private final String elementName;
    private final TextColor color;
    private final Key key;
    public static final Set<Element> VALUES;
    public static final List<String> NAMES;

    private Element(String elementName, TextColor color) {
        this.elementName = elementName;
        this.color = color;
        this.key = KeyUtil.simple("element." + elementName.toLowerCase(Locale.ROOT));
    }

    public String toString() {
        return this.elementName;
    }

    public Key key() {
        return this.key;
    }

    public String translationKey() {
        return KeyUtil.concat(this.key);
    }

    public Component displayName() {
        return Component.translatable((String)this.translationKey(), (TextColor)this.color);
    }

    public Component description() {
        return Component.translatable((String)(this.translationKey() + ".description"), (TextColor)this.color);
    }

    public TextColor color() {
        return this.color;
    }

    public static @Nullable Element fromName(String value) {
        if (!value.isEmpty()) {
            String upper = value.toUpperCase(Locale.ROOT);
            for (Element element : VALUES) {
                if (!element.name().startsWith(upper)) continue;
                return element;
            }
        }
        return null;
    }

    static {
        VALUES = ElementSet.copyOf(List.of(Element.values()));
        NAMES = List.of("Air", "Water", "Earth", "Fire");
    }
}

