/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.preset;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.api.util.functional.Suppliers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Preset {
    private static final Preset EMPTY = new Preset("", new AbilityDescription[9]);
    private final String name;
    private final AbilityDescription[] abilities;
    private final Supplier<TextColor> presetColor;

    private Preset(String name, Preset other) {
        this.name = name;
        this.abilities = other.abilities;
        this.presetColor = other.presetColor;
    }

    private Preset(String name, @Nullable AbilityDescription[] abilities) {
        this.name = name;
        this.abilities = new AbilityDescription[9];
        System.arraycopy(abilities, 0, this.abilities, 0, Math.min(9, abilities.length));
        this.presetColor = Suppliers.lazy(this::dominantColor);
    }

    public String name() {
        return this.name;
    }

    public Component displayName() {
        return Component.text((String)this.name, (TextColor)this.presetColor.get());
    }

    public List<@Nullable AbilityDescription> abilities() {
        return Collections.unmodifiableList(Arrays.asList(this.abilities));
    }

    public boolean isEmpty() {
        return this.matchesBinds(EMPTY);
    }

    public boolean matchesBinds(Preset other) {
        return this.matchesBinds(other.abilities);
    }

    public boolean matchesBinds(AbilityDescription[] other) {
        return Arrays.equals(this.abilities, other);
    }

    public void copyTo(AbilityDescription[] destination) {
        System.arraycopy(this.abilities, 0, destination, 0, 9);
    }

    public void forEach(ObjIntConsumer<AbilityDescription> consumer) {
        for (int idx = 0; idx < this.abilities.length; ++idx) {
            AbilityDescription desc = this.abilities[idx];
            if (desc == null) continue;
            consumer.accept(desc, idx);
        }
    }

    private TextColor dominantColor() {
        EnumMap counter = new EnumMap(Element.class);
        this.forEach((desc, idx) -> desc.elements().forEach((? super T element) -> counter.merge((Element)((Object)element), 1, Integer::sum)));
        return counter.entrySet().stream().max(Map.Entry.comparingByValue()).map(e -> ((Element)((Object)((Object)e.getKey()))).color()).orElse(ColorPalette.NEUTRAL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Preset other = (Preset)obj;
        return this.name.equals(other.name) && Arrays.equals(this.abilities, other.abilities);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + Arrays.hashCode(this.abilities);
    }

    public Preset withName(String newName) {
        if (this.isEmpty() || this.name.equals(newName)) {
            return this;
        }
        Preset.validateName(newName);
        return new Preset(newName, this);
    }

    public static Preset from(AbilityDescription[] abilities) {
        Objects.requireNonNull(abilities);
        return Preset.createOrReuseEmpty("", abilities);
    }

    public static Preset create(String name, AbilityDescription[] abilities) {
        Objects.requireNonNull(abilities);
        Preset.validateName(name);
        return Preset.createOrReuseEmpty(name, abilities);
    }

    private static Preset createOrReuseEmpty(String name, AbilityDescription[] abilities) {
        if (EMPTY.matchesBinds(abilities)) {
            return EMPTY;
        }
        return new Preset(name, abilities);
    }

    public static Preset empty() {
        return EMPTY;
    }

    private static void validateName(String name) throws IllegalArgumentException {
        String validatedName = TextUtil.sanitizeInput(name);
        if (!validatedName.equals(name)) {
            throw new IllegalArgumentException("Invalid preset name: " + name);
        }
    }
}

