/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.ability.state;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.state.DummyState;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.platform.block.Block;

public class StateChain
implements Updatable {
    private final Collection<Block> chainStore;
    private final Queue<State> chainQueue;
    private State currentState = DummyState.INSTANCE;
    private boolean started = false;
    private boolean finished = false;

    public StateChain() {
        this.chainStore = new ArrayList<Block>();
        this.chainQueue = new ArrayDeque<State>();
    }

    public StateChain(Collection<Block> store) {
        this();
        this.chainStore.addAll(store);
    }

    public StateChain addState(State state) {
        if (this.started) {
            throw new IllegalStateException("State is executing");
        }
        this.chainQueue.offer(state);
        return this;
    }

    public StateChain start() {
        if (this.started) {
            throw new IllegalStateException("State is executing");
        }
        if (this.chainQueue.isEmpty()) {
            throw new IllegalStateException("Chain is empty");
        }
        this.started = true;
        this.nextState();
        return this;
    }

    public State current() {
        return this.currentState;
    }

    public void nextState() {
        if (this.chainQueue.isEmpty()) {
            this.finished = true;
            return;
        }
        this.currentState = this.chainQueue.poll();
        this.currentState.start(this);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (!this.started || this.finished) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.currentState.update();
    }

    public void abort() {
        this.finished = true;
    }

    public boolean completed() {
        return this.finished && this.chainQueue.isEmpty();
    }

    public boolean finished() {
        return this.finished;
    }

    public Collection<Block> chainStore() {
        return this.chainStore;
    }
}

