/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.adapter;

import me.moros.bending.api.adapter.PacketUtil;
import me.moros.bending.api.event.BendingDamageEvent;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface NativeAdapter
extends PacketUtil {
    default public boolean damage(BendingDamageEvent event) {
        return event.target().damage(event.damage(), event.user());
    }

    default public boolean setBlockFast(Block block, BlockState state) {
        block.world().setBlockState(block, state);
        return true;
    }

    private Block eyeBlock(Entity entity) {
        Vector3d loc = entity.location();
        int x = loc.blockX();
        int y = FastMath.floor(loc.y() + entity.height() * 0.85 - 0.11);
        int z = loc.blockZ();
        return entity.world().blockAt(x, y, z);
    }

    default public boolean eyeInWater(Entity entity) {
        return MaterialUtil.isWater(this.eyeBlock(entity));
    }

    default public boolean eyeInLava(Entity entity) {
        return MaterialUtil.isLava(this.eyeBlock(entity));
    }

    default public boolean tryPowerLightningRod(Block block) {
        return block.type() == BlockType.LIGHTNING_ROD;
    }
}

