/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.collision.geometry;

import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.OBBImpl;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;

public sealed interface OBB
extends Collider
permits OBBImpl {
    public Vector3d axis(int var1);

    public Vector3d extents();

    public Vector3d localSpace(Vector3d var1);

    public Vector3d closestPosition(Vector3d var1);

    @Override
    default public Collider.Type type() {
        return Collider.Type.OBB;
    }

    @Override
    public OBB at(Position var1);

    @Override
    default public Vector3d halfExtents() {
        return this.localSpace(this.extents()).abs();
    }

    @Override
    default public boolean contains(Vector3d point) {
        return this.closestPosition(point).distanceSq(point) < 0.001;
    }

    public static OBB of(AABB aabb, Vector3d axis, double angle) {
        return OBB.of(aabb, Rotation.from(axis, angle));
    }

    public static OBB of(AABB aabb, Rotation rotation) {
        return OBBImpl.from(aabb, rotation);
    }

    public static OBB of(AABB aabb) {
        return new OBBImpl(aabb.position(), aabb.halfExtents(), aabb, new Vector3d[]{Vector3d.PLUS_I, Vector3d.PLUS_J, Vector3d.PLUS_K});
    }
}

