/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.block;

import me.moros.bending.api.platform.block.BlockPropertiesImpl;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.sound.SoundGroup;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.translation.Translatable;

public interface BlockProperties
extends Keyed,
Translatable {
    public boolean isAir();

    public boolean isSolid();

    public boolean isLiquid();

    public boolean isFlammable();

    public boolean hasGravity();

    public boolean isCollidable();

    public double hardness();

    public SoundGroup soundGroup();

    public static Builder builder(BlockType type, String translationKey) {
        return new Builder(type.key(), translationKey);
    }

    public static final class Builder {
        final Key key;
        final String translationKey;
        boolean isAir;
        boolean isSolid;
        boolean isLiquid;
        boolean isFlammable;
        boolean hasGravity;
        boolean isCollidable;
        double hardness;
        SoundGroup soundGroup;

        private Builder(Key key, String translationKey) {
            this.key = key;
            this.translationKey = translationKey;
        }

        public Builder isAir(boolean isAir) {
            this.isAir = isAir;
            return this;
        }

        public Builder isSolid(boolean isSolid) {
            this.isSolid = isSolid;
            return this;
        }

        public Builder isLiquid(boolean isLiquid) {
            this.isLiquid = isLiquid;
            return this;
        }

        public Builder isFlammable(boolean isFlammable) {
            this.isFlammable = isFlammable;
            return this;
        }

        public Builder hasGravity(boolean hasGravity) {
            this.hasGravity = hasGravity;
            return this;
        }

        public Builder isCollidable(boolean isCollidable) {
            this.isCollidable = isCollidable;
            return this;
        }

        public Builder hardness(double hardness) {
            this.hardness = hardness;
            return this;
        }

        public Builder soundGroup(SoundGroup soundGroup) {
            this.soundGroup = soundGroup;
            return this;
        }

        public BlockProperties build() {
            return new BlockPropertiesImpl(this);
        }
    }
}

