/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.platform.entity.player;

import java.util.List;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.PlayerInventory;
import me.moros.math.Vector3d;
import net.kyori.adventure.text.Component;

public interface Player
extends LivingEntity {
    @Override
    default public boolean isOnGround() {
        AABB entityBounds = this.bounds().grow(Vector3d.of(0.0, 0.05, 0.0));
        AABB floorBounds = AABB.of(Vector3d.of(-1.0, -0.1, -1.0), Vector3d.of(1.0, 0.1, 1.0)).at(this.location());
        for (Block block : this.world().nearbyBlocks(floorBounds, b -> b.type().isCollidable())) {
            if (!entityBounds.intersects(block.bounds())) continue;
            return true;
        }
        return false;
    }

    @Override
    public PlayerInventory inventory();

    public boolean hasPermission(String var1);

    public boolean canSee(Entity var1);

    default public void sendNotification(Item item, Component title) {
        Platform.instance().nativeAdapter().createNotification(item, title).send(List.of(this.uuid()));
    }
}

