/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.registry;

import me.moros.bending.api.registry.Registry;

public interface MutableRegistry<K, V>
extends Registry<K, V> {
    public boolean invalidateKey(K var1);

    public boolean invalidateValue(V var1);

    default public int invalidateKeys(Iterable<K> keys) {
        int counter = 0;
        if (!this.isLocked()) {
            for (K key : keys) {
                if (!this.invalidateKey(key)) continue;
                ++counter;
            }
        }
        return counter;
    }

    default public int invalidateValues(Iterable<V> values) {
        int counter = 0;
        if (!this.isLocked()) {
            for (V value : values) {
                if (!this.invalidateValue(value)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public boolean clear();
}

