/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.temporal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.event.ActionLimitEvent;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.temporal.Temporary;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingBar;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.util.TriState;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ActionLimiter
extends Temporary {
    public static final TemporalManager<UUID, ActionLimiter> MANAGER = new TemporalManager<UUID, ActionLimiter>(600){

        @Override
        public void tick() {
            super.tick();
            BARS.entrySet().removeIf(e -> ((BendingBar)e.getValue()).update() == Updatable.UpdateResult.REMOVE);
        }
    };
    private static final Map<UUID, BendingBar> BARS = new HashMap<UUID, BendingBar>();
    private final UUID uuid;
    private final LivingEntity entity;
    private final TriState hadAI;
    private final Set<ActionType> limitedActions;
    private boolean reverted = false;

    private ActionLimiter(LivingEntity entity, Collection<ActionType> limitedActions, boolean showBar, int ticks) {
        this.uuid = entity.uuid();
        this.entity = entity;
        this.limitedActions = EnumSet.copyOf(limitedActions);
        if (limitedActions.contains((Object)ActionType.MOVE)) {
            this.hadAI = entity.checkProperty(EntityProperties.AI);
            entity.setProperty(EntityProperties.AI, false);
        } else {
            this.hadAI = TriState.NOT_SET;
        }
        if (showBar && ticks > 2 && entity instanceof Player) {
            Player player = (Player)entity;
            BossBar bar = BossBar.bossBar((Component)Component.text((String)"Restricted"), (float)1.0f, (BossBar.Color)BossBar.Color.YELLOW, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
            BARS.putIfAbsent(this.uuid, BendingBar.of(bar, player, ticks));
        }
        MANAGER.addEntry(this.uuid, this, ticks);
    }

    @Override
    public boolean revert() {
        if (this.reverted) {
            return false;
        }
        this.reverted = true;
        MANAGER.removeEntry(this.uuid);
        BendingBar bar = BARS.remove(this.uuid);
        if (bar != null) {
            bar.onRemove();
        }
        this.entity.setProperty(EntityProperties.AI, this.hadAI);
        return true;
    }

    public static boolean isLimited(UUID uuid) {
        return ActionLimiter.isLimited(uuid, null);
    }

    public static boolean isLimited(UUID uuid, @Nullable ActionType method) {
        ActionLimiter limiter = MANAGER.get(uuid).orElse(null);
        if (limiter == null) {
            return false;
        }
        return method == null || limiter.limitedActions.contains((Object)method);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Set<ActionType> limitedActions = EnumSet.allOf(ActionType.class);
        private boolean showBar = true;
        private long duration = 5000L;

        private Builder() {
        }

        public Builder limit(Collection<ActionType> methods) {
            this.limitedActions = EnumSet.copyOf(methods);
            return this;
        }

        public Builder limit(ActionType method, ActionType ... methods) {
            ArrayList<ActionType> c = new ArrayList<ActionType>();
            c.add(method);
            if (methods != null) {
                c.addAll(List.of(methods));
            }
            return this.limit(c);
        }

        public Builder showBar(boolean showBar) {
            this.showBar = showBar;
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Optional<ActionLimiter> build(User source, LivingEntity target) {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            if (ActionLimiter.isLimited(target.uuid())) {
                return Optional.empty();
            }
            ActionLimitEvent event = source.game().eventBus().postActionLimitEvent(source, target, this.duration);
            if (event.cancelled() || event.duration() <= 0L) {
                return Optional.empty();
            }
            return Optional.of(new ActionLimiter(target, this.limitedActions, this.showBar, MANAGER.fromMillis(event.duration())));
        }
    }
}

