/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import me.moros.bending.api.registry.Registry;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TextUtil {
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern SPACE = Pattern.compile(" ");

    private TextUtil() {
    }

    public static String sanitizeInput(@Nullable String input) {
        if (input == null) {
            return "";
        }
        String output = NON_ALPHANUMERIC.matcher(input).replaceAll("").toLowerCase(Locale.ROOT);
        return output.length() > 16 ? output.substring(0, 16) : output;
    }

    public static List<String> wrap(String str, int wrapLength) {
        wrapLength = Math.max(1, wrapLength);
        int length = str.length();
        int offset = 0;
        ArrayList<String> lines = new ArrayList<String>(length / wrapLength);
        while (offset < length) {
            int spaceToWrapAt = -1;
            Matcher matcher = SPACE.matcher(str.substring(offset, Math.min(offset + wrapLength + 1, length)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start() + offset;
            }
            if (length - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                lines.add(str.substring(offset, spaceToWrapAt));
                offset = spaceToWrapAt + 1;
                continue;
            }
            matcher = SPACE.matcher(str.substring(offset + wrapLength));
            if (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset + wrapLength;
            }
            if (spaceToWrapAt >= 0) {
                lines.add(str.substring(offset, spaceToWrapAt));
                offset = spaceToWrapAt + 1;
                continue;
            }
            lines.add(str.substring(offset, length));
            offset = length;
        }
        lines.add(str.substring(offset, length));
        return lines;
    }

    public static @Nullable UUID parseUUID(String input) {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static String collect(Registry<Key, ?> registry) {
        return TextUtil.collect(registry.keys(), Key::value);
    }

    public static <T> String collect(Iterable<T> values, Function<T, String> function) {
        return StreamSupport.stream(values.spliterator(), false).map(function).collect(Collectors.joining(", ", "[", "]"));
    }
}

