/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.api.util.collect;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.util.collect.ElementSet;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MutableElementSet
extends AbstractSet<Element>
implements ElementSet {
    static final int SPLITERATOR_CHARACTERISTICS = 16725;
    private static final Element[] UNIVERSE = (Element[])Element.values().clone();
    private final AtomicInteger elements = new AtomicInteger(0);

    MutableElementSet() {
    }

    @Override
    public int elements() {
        return this.elements.get();
    }

    @Override
    public int size() {
        return Integer.bitCount(this.elements.get());
    }

    @Override
    public boolean isEmpty() {
        return this.elements.get() == 0;
    }

    @Override
    public boolean contains(Object e) {
        if (e == null || e.getClass() != Element.class) {
            return false;
        }
        return (this.elements.get() & 1 << ((Element)((Object)e)).ordinal()) != 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ElementSet other;
        return c instanceof ElementSet ? ((other = (ElementSet)c).elements() & ~this.elements.get()) == 0 : super.containsAll(c);
    }

    @Override
    public boolean set(@Nullable Set<Element> other) {
        int value;
        if (other == null) {
            return false;
        }
        if (other instanceof ElementSet) {
            ElementSet otherElementSet = (ElementSet)other;
            value = otherElementSet.elements();
        } else {
            value = 0;
            for (Element element : other) {
                value |= 1 << element.ordinal();
            }
        }
        return this.elements.getAndSet(value) != value;
    }

    @Override
    public boolean add(@Nullable Element e) {
        if (e == null) {
            return false;
        }
        int modifier = 1 << e.ordinal();
        return this.elements.getAndUpdate(curr -> curr | modifier) != this.elements.get();
    }

    @Override
    public boolean remove(@Nullable Object e) {
        if (e == null || e.getClass() != Element.class) {
            return false;
        }
        int modifier = ~(1 << ((Element)((Object)e)).ordinal());
        return this.elements.getAndUpdate(curr -> curr & modifier) != this.elements.get();
    }

    @Override
    public boolean addAll(Collection<? extends Element> c) {
        if (!(c instanceof ElementSet)) {
            return super.addAll(c);
        }
        ElementSet other = (ElementSet)c;
        int modifier = other.elements();
        return this.elements.getAndUpdate(curr -> curr | modifier) != this.elements.get();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!(c instanceof ElementSet)) {
            return super.removeAll(c);
        }
        ElementSet other = (ElementSet)c;
        int modifier = ~other.elements();
        return this.elements.getAndUpdate(curr -> curr & modifier) != this.elements.get();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof ElementSet)) {
            return super.retainAll(c);
        }
        ElementSet other = (ElementSet)c;
        int modifier = other.elements();
        return this.elements.getAndUpdate(curr -> curr & modifier) != this.elements.get();
    }

    @Override
    public void clear() {
        this.elements.set(0);
    }

    @Override
    public boolean equals(Object obj) {
        ElementSet other;
        return obj instanceof ElementSet ? (other = (ElementSet)obj).elements() == this.elements.get() : super.equals(obj);
    }

    @Override
    public Iterator<Element> iterator() {
        return new Itr(this.elements.get());
    }

    @Override
    public Spliterator<Element> spliterator() {
        return Spliterators.spliterator(this, 16725);
    }

    static final class Itr
    implements Iterator<Element> {
        private int unseen;

        Itr(int elements) {
            this.unseen = elements;
        }

        @Override
        public boolean hasNext() {
            return this.unseen != 0;
        }

        @Override
        public Element next() {
            if (this.unseen == 0) {
                throw new NoSuchElementException();
            }
            int lastReturned = this.unseen & -this.unseen;
            this.unseen -= lastReturned;
            return UNIVERSE[Integer.numberOfTrailingZeros(lastReturned)];
        }
    }
}

